/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.commands;

import com.scriptbasic.executors.commands.AbstractCommand;
import com.scriptbasic.executors.commands.CommandNext;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.NumberUtility;

public class CommandFor
extends AbstractCommand {
    private LeftValue loopVariable;
    private Expression loopStartValue;
    private Expression loopEndValue;
    private Expression loopStepValue;
    private CommandNext loopEndNode;
    private RightValue loopStart;
    private RightValue loopEnd;
    private RightValue loopStep;

    public RightValue getLoopEnd() {
        return this.loopEnd;
    }

    public RightValue getLoopStep() {
        return this.loopStep;
    }

    public CommandNext getLoopEndNode() {
        return this.loopEndNode;
    }

    public void setLoopEndNode(CommandNext loopEndNode) {
        this.loopEndNode = loopEndNode;
    }

    public LeftValue getLoopVariable() {
        return this.loopVariable;
    }

    public void setLoopVariable(LeftValue loopVariable) {
        this.loopVariable = loopVariable;
    }

    public Expression getLoopStartValue() {
        return this.loopStartValue;
    }

    public void setLoopStartValue(Expression loopStartValue) {
        this.loopStartValue = loopStartValue;
    }

    public Expression getLoopEndValue() {
        return this.loopEndValue;
    }

    public void setLoopEndValue(Expression loopEndValue) {
        this.loopEndValue = loopEndValue;
    }

    public Expression getLoopStepValue() {
        return this.loopStepValue;
    }

    public void setLoopStepValue(Expression loopStepValue) {
        this.loopStepValue = loopStepValue;
    }

    private void startLoopWithLong(ExtendedInterpreter interpreter) throws ExecutionException {
        Long start = BasicLongValue.convert(this.loopStart);
        this.loopVariable.setValue(new BasicLongValue(start), interpreter);
        this.setNextCommand(interpreter, BasicLongValue.convert(this.loopStep), start, BasicLongValue.convert(this.loopEnd));
    }

    private void startLoopWithDouble(ExtendedInterpreter interpreter) throws ExecutionException {
        Double start = BasicDoubleValue.convert(this.loopStart);
        this.loopVariable.setValue(new BasicDoubleValue(start), interpreter);
        this.setNextCommand(interpreter, BasicDoubleValue.convert(this.loopStep), start, BasicDoubleValue.convert(this.loopEnd));
    }

    private RightValue getLoopVariableAsRightValue(ExtendedInterpreter interpreter) throws ExecutionException {
        return interpreter.getVariables().getVariableValue(((BasicLeftValue)this.loopVariable).getIdentifier());
    }

    private void finishTheLoop(ExtendedInterpreter interpreter) {
        interpreter.setNextCommand(this.loopEndNode.getNextCommand());
    }

    private <T extends Number> void setNextCommand(ExtendedInterpreter interpreter, T step, T newLoopValue, T loopEndDouble) {
        if (NumberUtility.isPositive(step)) {
            if (NumberUtility.compare(newLoopValue, loopEndDouble) <= 0) {
                interpreter.setNextCommand(this.getNextCommand());
            } else {
                this.finishTheLoop(interpreter);
            }
        } else if (NumberUtility.compare(newLoopValue, loopEndDouble) >= 0) {
            interpreter.setNextCommand(this.getNextCommand());
        } else {
            this.finishTheLoop(interpreter);
        }
    }

    private void stepLoopVariable(ExtendedInterpreter interpreter, Long step) throws ExecutionException {
        Long loopEndValue = BasicLongValue.convert(this.loopEnd);
        RightValue rv = this.getLoopVariableAsRightValue(interpreter);
        Long newLoopValue = BasicLongValue.convert(rv) + step;
        this.loopVariable.setValue(new BasicLongValue(newLoopValue), interpreter);
        this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
    }

    private void stepLoopVariable(ExtendedInterpreter interpreter, Double step) throws ExecutionException {
        Double loopEndValue = BasicDoubleValue.convert(this.loopEnd);
        RightValue rv = this.getLoopVariableAsRightValue(interpreter);
        Double newLoopValue = BasicDoubleValue.convert(rv) + step;
        this.loopVariable.setValue(new BasicDoubleValue(newLoopValue), interpreter);
        this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void stepLoopVariable(ExtendedInterpreter interpreter) throws ExecutionException {
        if (!(this.loopVariable instanceof BasicLeftValue)) throw new BasicRuntimeException("Loop variable is not BasicLeftValue, this is probably internal error");
        if (this.loopStep instanceof BasicLongValue) {
            this.stepLoopVariable(interpreter, BasicLongValue.convert(this.loopStep));
            return;
        } else {
            if (!(this.loopStep instanceof BasicDoubleValue)) throw new BasicRuntimeException("Loop step value can be long or double");
            this.stepLoopVariable(interpreter, BasicDoubleValue.convert(this.loopStep));
        }
    }

    void noStepLoopVariable(ExtendedInterpreter interpreter) throws ExecutionException {
        if (this.loopStep instanceof BasicLongValue) {
            Long step = BasicLongValue.convert(this.loopStep);
            Long loopEndValue = BasicLongValue.convert(this.loopEnd);
            Long newLoopValue = BasicLongValue.convert(this.getLoopVariableAsRightValue(interpreter));
            this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
        } else if (this.loopStep instanceof BasicDoubleValue) {
            Double step = BasicDoubleValue.convert(this.loopStep);
            Double loopEndValue = BasicDoubleValue.convert(this.loopEnd);
            Double newLoopValue = BasicDoubleValue.convert(this.getLoopVariableAsRightValue(interpreter));
            this.setNextCommand(interpreter, step, newLoopValue, loopEndValue);
        } else {
            throw new BasicRuntimeException("Loop step value can be long or double");
        }
    }

    private void setLoopStart(ExtendedInterpreter interpreter) throws ExecutionException {
        if (this.loopStep instanceof BasicDoubleValue) {
            if (this.loopStart instanceof BasicDoubleValue) {
                this.loopVariable.setValue(this.loopStart, interpreter);
            } else {
                this.startLoopWithDouble(interpreter);
            }
        } else if (this.loopStep instanceof BasicLongValue) {
            if (this.loopStart instanceof BasicLongValue) {
                this.loopVariable.setValue(this.loopStart, interpreter);
            } else {
                this.startLoopWithLong(interpreter);
            }
        } else {
            throw new BasicRuntimeException("Step expression is not long or double");
        }
    }

    @Override
    public void execute(ExtendedInterpreter interpreter) throws ExecutionException {
        this.loopStart = this.loopStartValue.evaluate(interpreter);
        this.loopEnd = this.loopEndValue.evaluate(interpreter);
        this.loopStep = this.loopStepValue != null ? this.loopStepValue.evaluate(interpreter) : new BasicLongValue(1L);
        this.setLoopStart(interpreter);
        this.noStepLoopVariable(interpreter);
    }
}

