/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.leftvalues;

import com.scriptbasic.executors.leftvalues.AbstractLeftValue;
import com.scriptbasic.executors.leftvalues.ArrayElementAccessLeftValueModifier;
import com.scriptbasic.executors.leftvalues.LeftValueModifier;
import com.scriptbasic.executors.leftvalues.ObjectFieldAccessLeftValueModifier;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.HierarchicalVariableMap;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.RightValueUtility;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BasicLeftValue
extends AbstractLeftValue {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLeftValue.class);
    private String identifier;
    private final List<LeftValueModifier> modifiers = new LinkedList<LeftValueModifier>();

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public List<LeftValueModifier> getModifiers() {
        return this.modifiers;
    }

    public boolean hasModifiers() {
        return this.modifiers != null && this.modifiers.size() > 0;
    }

    public void addModifier(LeftValueModifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public void setValue(RightValue rightValue, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        HierarchicalVariableMap variableMap = extendedInterpreter.getVariables();
        if (this.modifiers == null || this.modifiers.isEmpty()) {
            LOG.debug("setting the variable '{}'", this.getIdentifier());
            variableMap.setVariable(this.getIdentifier(), rightValue);
        } else {
            RightValue variable = variableMap.getVariableValue(this.getIdentifier());
            if (variable == null) {
                variable = new BasicArrayValue(extendedInterpreter);
                variableMap.setVariable(this.getIdentifier(), variable);
            }
            Iterator<LeftValueModifier> modifierIterator = this.modifiers.iterator();
            while ((variable = BasicLeftValue.handleAccessModifier(variable, modifierIterator.next(), modifierIterator.hasNext(), rightValue, extendedInterpreter)) != null) {
            }
        }
    }

    private static RightValue handleAccessModifier(RightValue variable, LeftValueModifier modifier, boolean hasNext, RightValue rightValue, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        if (modifier instanceof ArrayElementAccessLeftValueModifier) {
            variable = BasicLeftValue.handleArrayElementAccess(variable, (ArrayElementAccessLeftValueModifier)modifier, hasNext, rightValue, extendedInterpreter);
        } else if (modifier instanceof ObjectFieldAccessLeftValueModifier) {
            variable = BasicLeftValue.handleObjectFieldAccess(variable, (ObjectFieldAccessLeftValueModifier)modifier, hasNext, rightValue, extendedInterpreter);
        }
        return variable;
    }

    private static RightValue handleObjectFieldAccess(RightValue variable, ObjectFieldAccessLeftValueModifier modifier, boolean hasNext, RightValue rightValue, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        String fieldName = modifier.getFieldName();
        if (!(variable instanceof BasicJavaObjectValue)) {
            throw new BasicRuntimeException(variable + " is not an object, can not access its field '" + fieldName + "'");
        }
        BasicJavaObjectValue bjov = (BasicJavaObjectValue)variable;
        Object object = bjov.getValue();
        if (hasNext) {
            Object fieldObject = KlassUtility.getField(object, fieldName);
            variable = RightValueUtility.createRightValue(fieldObject);
            return variable;
        }
        Object valueObject = RightValueUtility.getValueObject(rightValue);
        KlassUtility.setField(object, fieldName, valueObject);
        return null;
    }

    private static RightValue handleArrayElementAccess(RightValue variable, ArrayElementAccessLeftValueModifier modifier, boolean hasNext, RightValue rightValue, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        Iterator expressionIterator = modifier.getIndexList().iterator();
        while (expressionIterator.hasNext()) {
            Expression expression = (Expression)expressionIterator.next();
            RightValue index = expression.evaluate(extendedInterpreter);
            if (variable instanceof BasicArrayValue) {
                variable = BasicLeftValue.handleBasicArrayElementAccess((BasicArrayValue)variable, RightValueUtility.convert2Integer(index), hasNext || expressionIterator.hasNext(), rightValue, extendedInterpreter);
                continue;
            }
            throw new BasicRuntimeException(variable + " is not an array, can not access its index");
        }
        return variable;
    }

    private static RightValue handleBasicArrayElementAccess(BasicArrayValue variable, Integer index, boolean hasNext, RightValue rightValue, ExtendedInterpreter extendedInterpreter) throws ExecutionException {
        if (hasNext) {
            RightValue arrayElement;
            Object object = variable.get(index);
            if (object instanceof RightValue) {
                arrayElement = (RightValue)object;
            } else {
                arrayElement = new BasicArrayValue(extendedInterpreter);
                variable.set(index, arrayElement);
            }
            return arrayElement;
        }
        variable.set(index, rightValue);
        return null;
    }
}

