/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.factories;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.factories.ManagedObjectsStore;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.FactoryManaged;
import java.util.Iterator;
import java.util.ServiceLoader;

public class BasicFactory
implements Factory {
    private final ManagedObjectsStore store = new ManagedObjectsStore();

    private static void assertInterface(Class<? extends FactoryManaged> interfAce) {
        if (!interfAce.isInterface()) {
            throw new IllegalArgumentException("The class " + interfAce + " is not an interface, can not be used in this factory.");
        }
    }

    private <T extends FactoryManaged> void load(Class<T> interfAce) {
        ServiceLoader<T> loader = ServiceLoader.load(interfAce);
        Iterator<T> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new BasicInterpreterInternalError("Can not instantiate " + interfAce);
        }
        FactoryManaged object = (FactoryManaged)iterator.next();
        this.store.set(interfAce, object);
        object.setFactory(this);
    }

    @Override
    public <T extends FactoryManaged> T get(Class<T> interfAce) {
        BasicFactory.assertInterface(interfAce);
        T object = this.store.get(interfAce);
        if (object == null) {
            this.load(interfAce);
            object = this.store.get(interfAce);
        }
        return object;
    }

    @Override
    public void clean() {
        this.store.clean();
    }
}

