/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.main;

import com.scriptbasic.factories.BasicFactory;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.readers.GenericReader;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.functions.file.FileHandlingFunctions;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandLineExtended {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block10: {
            if (args.length != 1) {
                System.err.println("usage: java [-Dsb4j.extensionclasses=comma separated list of extension classes] [-cp classpath for extensions] -jar jscriptbasic-x.y.z basicprogram.sb");
                System.exit(1);
            }
            Logger.getLogger("").setLevel(Level.SEVERE);
            String basicProgramFileName = args[0];
            int extensionDotPosition = basicProgramFileName.indexOf(46);
            String extension = extensionDotPosition > -1 ? basicProgramFileName.substring(extensionDotPosition + 1) : "";
            BasicFactory factory = new BasicFactory();
            FileReader r = new FileReader(basicProgramFileName);
            GenericReader reader = new GenericReader();
            reader.set(r);
            reader.setSourceProvider(null);
            reader.set(basicProgramFileName);
            LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(factory);
            lexicalAnalyzer.set(reader);
            ExtendedInterpreter interpreter = FactoryUtility.getExtendedInterpreter(factory);
            interpreter.registerFunctions(FileHandlingFunctions.class);
            String classes = System.getProperty("sb4j.extensionclasses");
            if (classes != null && classes.length() > 0) {
                String[] classNames;
                for (String className : classNames = classes.split(",")) {
                    Class<?> klass = Class.forName(className);
                    interpreter.registerFunctions(klass);
                }
            }
            PrintWriter outWriter = new PrintWriter(System.out);
            PrintWriter errorWriter = new PrintWriter(System.err);
            try {
                interpreter.setProgram(FactoryUtility.getSyntaxAnalyzer(factory).analyze());
                interpreter.setWriter(outWriter);
                interpreter.setErrorWriter(errorWriter);
                interpreter.setReader(new InputStreamReader(System.in));
                interpreter.execute();
            }
            catch (Exception sce) {
                Exception cause = (Exception)sce.getCause();
                if (cause == null) {
                    cause = sce;
                }
                if (cause.getMessage() != null) {
                    System.err.println("ERROR: " + cause.getMessage());
                    break block10;
                }
                throw sce;
            }
            finally {
                outWriter.flush();
                errorWriter.flush();
            }
        }
    }
}

