/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.api;

import com.scriptbasic.Engine;
import com.scriptbasic.api.Configuration;
import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.api.Subroutine;
import com.scriptbasic.readers.SourcePath;
import com.scriptbasic.readers.SourceProvider;
import com.scriptbasic.spi.InterpreterHook;
import com.scriptbasic.utility.functions.file.FileHandlingFunctions;
import java.io.File;
import java.io.Reader;
import java.io.Writer;

public interface ScriptBasic {
    public static final Class<FileHandlingFunctions> fileHandlingFunctionsClass = FileHandlingFunctions.class;

    public static ScriptBasic engine() {
        return new Engine();
    }

    public void registerFunction(String var1, Class<?> var2, String var3, Class<?> ... var4) throws ScriptBasicException;

    default public FunctionBuilder function(String methodName) {
        return new FunctionBuilder(methodName, this);
    }

    public Reader getInput();

    @Deprecated
    public void setInput(Reader var1);

    default public ScriptBasic input(Reader input) {
        this.setInput(input);
        return this;
    }

    public Writer getOutput();

    @Deprecated
    public void setOutput(Writer var1);

    default public ScriptBasic output(Writer output) {
        this.setOutput(output);
        return this;
    }

    public Writer getErrorOutput();

    @Deprecated
    public void setErrorOutput(Writer var1);

    default public ScriptBasic error(Writer error) {
        this.setErrorOutput(error);
        return this;
    }

    public ScriptBasic load(String var1) throws ScriptBasicException;

    public ScriptBasic load(Reader var1) throws ScriptBasicException;

    public ScriptBasic load(File var1) throws ScriptBasicException;

    public ScriptBasic load(String var1, String ... var2) throws ScriptBasicException;

    public ScriptBasic load(String var1, SourcePath var2) throws ScriptBasicException;

    public ScriptBasic load(String var1, SourceProvider var2) throws ScriptBasicException;

    public ScriptBasic eval(String var1) throws ScriptBasicException;

    public ScriptBasic eval(Reader var1) throws ScriptBasicException;

    public ScriptBasic eval(File var1) throws ScriptBasicException;

    public ScriptBasic eval(String var1, String ... var2) throws ScriptBasicException;

    public ScriptBasic eval(String var1, SourcePath var2) throws ScriptBasicException;

    public ScriptBasic eval(String var1, SourceProvider var2) throws ScriptBasicException;

    public ScriptBasic execute() throws ScriptBasicException;

    @Deprecated
    public void setVariable(String var1, Object var2) throws ScriptBasicException;

    default public VariableBuilder variable(String name) {
        return new VariableBuilder(name, this);
    }

    @Deprecated(forRemoval=true)
    public Object getVariable(String var1) throws ScriptBasicException;

    public <T> T variable(Class<T> var1, String var2) throws ScriptBasicException;

    @Deprecated(forRemoval=true)
    public Iterable<String> getVariablesIterator() throws ScriptBasicException;

    public Iterable<String> variables() throws ScriptBasicException;

    public <T> Subroutine<T> subroutine(Class<T> var1, String var2) throws ScriptBasicException;

    public <T> Subroutine<T> subroutine(String var1) throws ScriptBasicException;

    public Iterable<Subroutine> subroutines() throws ScriptBasicException;

    public ScriptBasic registerExtension(Class<?> var1);

    public ScriptBasic registerHook(InterpreterHook var1);

    public Configuration getConfiguration();

    public static class FunctionBuilder {
        private final String methodName;
        private final ScriptBasic scriptBasic;
        private String alias;

        private FunctionBuilder(String methodName, ScriptBasic scriptBasic) {
            this.methodName = methodName;
            this.alias = methodName;
            this.scriptBasic = scriptBasic;
        }

        public FunctionBuilder2 klass(Class<?> klass) {
            return new FunctionBuilder2(klass);
        }

        public class FunctionBuilder2 {
            private final Class<?> klass;

            public FunctionBuilder2(Class<?> klass) {
                this.klass = klass;
            }

            public FunctionBuilder2 alias(String a) {
                FunctionBuilder.this.alias = a;
                return this;
            }

            public ScriptBasic arguments(Class<?> ... argumentTypes) throws ScriptBasicException {
                FunctionBuilder.this.scriptBasic.registerFunction(FunctionBuilder.this.alias, this.klass, FunctionBuilder.this.methodName, argumentTypes);
                return FunctionBuilder.this.scriptBasic;
            }
        }
    }

    public static class VariableBuilder {
        private final String name;
        private final ScriptBasic scriptBasic;

        private VariableBuilder(String name, ScriptBasic scriptBasic) {
            this.name = name;
            this.scriptBasic = scriptBasic;
        }

        public ScriptBasic is(Object value) throws ScriptBasicException {
            this.scriptBasic.setVariable(this.name, value);
            return this.scriptBasic;
        }
    }
}

