/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.BasicArray;
import com.scriptbasic.spi.BasicValue;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.RightValue;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class BasicArrayValue
implements RightValue,
BasicArray,
BasicValue<Object[]> {
    private static final Integer INCREMENT_GAP = 100;
    private Object[] array = new Object[INCREMENT_GAP.intValue()];
    private int maxIndex = -1;
    private Interpreter interpreter;
    private Integer indexLimit;

    public BasicArrayValue() {
        this.interpreter = null;
    }

    public BasicArrayValue(Interpreter interpreter) {
        this.setInterpreter(interpreter);
    }

    @Override
    public void setArray(Object[] array) throws ScriptBasicException {
        if (array == null) {
            throw new ScriptBasicException("BasicArrayValue embedded array cannot be null");
        }
        this.array = this.objectArrayOf(array);
        this.maxIndex = array.length - 1;
    }

    private Object[] objectArrayOf(Object[] array) {
        Object[] objectArray = array.getClass() == Object[].class ? array : Arrays.copyOf(array, array.length, Object[].class);
        return objectArray;
    }

    public final void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
        Optional<String> maxConfig = interpreter.getConfiguration().getConfigValue("arrayMaxIndex");
        maxConfig.ifPresent(s -> {
            this.indexLimit = Integer.valueOf(s);
        });
    }

    private void assertArraySize(Integer index) throws ScriptBasicException {
        if (index < 0) {
            throw new BasicRuntimeException("Array index can not be negative");
        }
        if (this.array.length <= index) {
            if (this.indexLimit != null && index > this.indexLimit) {
                throw new BasicRuntimeException("Array index is too large, the configured limit is " + this.indexLimit);
            }
            this.array = Arrays.copyOf(this.array, index + INCREMENT_GAP);
        }
    }

    @Override
    public long getLength() {
        return (long)this.maxIndex + 1L;
    }

    @Override
    public void set(Integer index, Object object) throws ScriptBasicException {
        this.assertArraySize(index);
        this.array[index.intValue()] = object;
        if (this.maxIndex < index) {
            this.maxIndex = index;
        }
    }

    @Override
    public Object get(Integer index) throws ScriptBasicException {
        this.assertArraySize(index);
        return this.array[index];
    }

    public String toString() {
        return "[" + Arrays.stream(this.array).limit(this.maxIndex + 1).map(Object::toString).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public Object[] getValue() {
        return Arrays.copyOf(this.array, this.maxIndex + 1);
    }
}

