/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.executors.commands.CommandEndSub;
import com.scriptbasic.executors.commands.CommandGlobal;
import com.scriptbasic.executors.commands.CommandLocal;
import com.scriptbasic.executors.commands.CommandMethod;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.executors.commands.CommandUse;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.BuildableProgram;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.spi.Command;
import java.util.Map;

public abstract class AbstractBasicProgramPostprocessing
implements BuildableProgram {
    private static final Logger LOG = LoggerFactory.getLogger();
    private Command startCommand = null;

    private static boolean commandIsSubHeadCommand(Command command) {
        return command instanceof CommandLocal || command instanceof CommandGlobal;
    }

    private static void signalGlobalLocal() throws AnalysisException {
        throw new BasicSyntaxException("Command 'LOCAL' can only be used inside a subroutine.");
    }

    private static void signalLocalCommandUse() throws AnalysisException {
        throw new BasicSyntaxException("Command 'USE' should not be used inside a subroutine.");
    }

    private static void signalLocalCommandMethod() throws AnalysisException {
        throw new BasicSyntaxException("Command 'METHOD' should not be used inside a subroutine.");
    }

    private static void signalMisplacedGlobalOrLocal() throws AnalysisException {
        throw new BasicSyntaxException("Global and Local declarations shoud be the first definitions in the Sub");
    }

    private static void signalNestedSub() throws AnalysisException {
        throw new BasicSyntaxException("Subroutines can not be nested into each other");
    }

    @Override
    public Command getStartCommand() {
        if (this.startCommand == null) {
            this.startCommand = this.getFirstCommand();
        }
        return this.startCommand;
    }

    protected abstract Map<String, CommandSub> getSubroutineMap();

    private void collectSubroutines() throws BasicSyntaxException {
        for (Command command = this.getFirstCommand(); command != null; command = command.getNextCommand()) {
            if (!(command instanceof CommandSub)) continue;
            CommandSub commandSub = (CommandSub)command;
            if (this.getSubroutineMap().containsKey(commandSub.getSubName())) {
                throw new BasicSyntaxException("The subroutine '" + commandSub.getSubName() + "' is defined more than once");
            }
            this.getSubroutineMap().put(commandSub.getSubName(), (CommandSub)command);
        }
    }

    private void skipDeclarations() {
        boolean loopIsInSub = false;
        int skipNr = 0;
        for (Command command : this.getCommands()) {
            ++skipNr;
            if (loopIsInSub) {
                if (!(command instanceof CommandEndSub)) continue;
                loopIsInSub = false;
                continue;
            }
            if (command instanceof CommandSub) {
                loopIsInSub = true;
                continue;
            }
            this.startCommand = command;
            LOG.info("basic program starts on the line #" + skipNr, new Object[0]);
            break;
        }
    }

    private void checkLocalAndGlobalDeclarations() throws AnalysisException {
        boolean inSub = false;
        boolean subHeadClosed = false;
        for (Command command : this.getCommands()) {
            if (inSub) {
                if (command instanceof CommandEndSub) {
                    inSub = false;
                    continue;
                }
                if (command instanceof CommandSub) {
                    AbstractBasicProgramPostprocessing.signalNestedSub();
                }
                if (command instanceof CommandUse) {
                    AbstractBasicProgramPostprocessing.signalLocalCommandUse();
                }
                if (command instanceof CommandMethod) {
                    AbstractBasicProgramPostprocessing.signalLocalCommandMethod();
                }
                if (subHeadClosed) {
                    if (!(command instanceof CommandLocal) && !(command instanceof CommandGlobal)) continue;
                    AbstractBasicProgramPostprocessing.signalMisplacedGlobalOrLocal();
                    continue;
                }
                subHeadClosed = !AbstractBasicProgramPostprocessing.commandIsSubHeadCommand(command);
                continue;
            }
            if (command instanceof CommandLocal) {
                AbstractBasicProgramPostprocessing.signalGlobalLocal();
            }
            if (!(command instanceof CommandSub)) continue;
            inSub = true;
            subHeadClosed = false;
        }
    }

    protected abstract Command getFirstCommand();

    @Override
    public void postprocess() throws AnalysisException {
        this.startCommand = this.getFirstCommand();
        this.checkLocalAndGlobalDeclarations();
        this.skipDeclarations();
        this.collectSubroutines();
    }
}

