/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.NestedStructure;
import com.scriptbasic.interfaces.NestedStructureHouseKeeper;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import java.util.Stack;

public abstract class AbstractNestedStructureHouseKeeper
implements NestedStructureHouseKeeper {
    private static final Logger LOG = LoggerFactory.getLogger();
    private static final Structure MATCH_NOTHING = new Structure(){

        @Override
        public <T> boolean match(Class<T> expectedClass) {
            return false;
        }
    };
    private final Stack<Structure> stack = new Stack();
    private final LexicalAnalyzer analyzer;
    private boolean stackIsHealthy = true;

    protected AbstractNestedStructureHouseKeeper(LexicalAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public void push(NestedStructure element) {
        this.push(element.getClass(), element);
    }

    protected boolean isStackIsHealthy() {
        return this.stackIsHealthy;
    }

    @Override
    public void push(Class<?> klass, NestedStructure element) {
        Structure stackFrame = new Structure();
        stackFrame.setElementType(klass);
        stackFrame.setPushedElement(element);
        this.stack.push(stackFrame);
    }

    @Override
    public <T extends NestedStructure> T pop(Class<T> expectedClass) throws AnalysisException {
        Structure stackFrame;
        Structure structure = stackFrame = this.stack.isEmpty() ? MATCH_NOTHING : this.stack.peek();
        if (!stackFrame.match(expectedClass)) {
            this.stackIsHealthy = false;
            BasicSyntaxException se = new BasicSyntaxException("Bad nested structures");
            try {
                se.setLocation(this.analyzer.peek());
            }
            catch (LexicalException e) {
                LOG.error("There was an error when trying to fetch the current source location", e);
            }
            throw se;
        }
        this.stack.pop();
        return (T)stackFrame.getPushedElement();
    }

    protected static class Structure {
        private Class<?> elementType;
        private NestedStructure pushedElement;

        protected Structure() {
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public void setElementType(Class<?> elementType) {
            this.elementType = elementType;
        }

        public NestedStructure getPushedElement() {
            return this.pushedElement;
        }

        public void setPushedElement(NestedStructure pushedElement) {
            this.pushedElement = pushedElement;
        }

        public <T> boolean match(Class<T> expectedClass) {
            return expectedClass.isAssignableFrom(this.getElementType());
        }
    }
}

