/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility.functions;

import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.spi.ClassSetProvider;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.utility.NoInstance;
import com.scriptbasic.utility.functions.ErrorFunctions;
import com.scriptbasic.utility.functions.MathFunctions;
import com.scriptbasic.utility.functions.StringFunctions;
import com.scriptbasic.utility.functions.UtilityFunctions;
import java.util.ServiceLoader;
import java.util.Set;

public class BasicRuntimeFunctionRegisterer {
    private static final Logger LOG = LoggerFactory.getLogger();
    private static final Set<Class<?>> basicRuntimeFunctionClasses = Set.of(ErrorFunctions.class, StringFunctions.class, UtilityFunctions.class, MathFunctions.class);

    private BasicRuntimeFunctionRegisterer() {
        NoInstance.isPossible();
    }

    public static void registerBasicRuntimeFunctions(Interpreter interpreter) {
        for (Class<?> klass : basicRuntimeFunctionClasses) {
            interpreter.registerFunctions(klass);
        }
        ServiceLoader.load(ClassSetProvider.class).forEach(provider -> provider.provide().forEach(klass -> {
            LOG.info("Registering class {}", klass);
            interpreter.registerFunctions((Class<?>)klass);
        }));
    }
}

