/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicEmptyValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.spi.RightValue;

public class BasicDoubleValue
extends AbstractNumericRightValue<Double, Double> {
    public BasicDoubleValue(Double d) {
        this.setValue(d);
    }

    public static Double asDouble(RightValue rv, String errorMessageForNull) throws BasicRuntimeException {
        Double value = BasicDoubleValue.asDouble(rv);
        if (value == null) {
            throw new BasicRuntimeException(errorMessageForNull);
        }
        return value;
    }

    public static Double asDouble(RightValue rv) throws BasicRuntimeException {
        Object o;
        if (rv.isBoolean().booleanValue()) {
            return (Boolean)((BasicBooleanValue)rv).getValue() != false ? 1.0 : 0.0;
        }
        if (rv.isString().booleanValue()) {
            String s = (String)((BasicStringValue)rv).getValue();
            if (s == null) {
                return null;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                throw new BasicRuntimeException("Can not convert value to double", e);
            }
        }
        if (rv.isLong().booleanValue()) {
            Long l = (Long)((BasicLongValue)rv).getValue();
            if (l == null) {
                return null;
            }
            return l.doubleValue();
        }
        if (rv.isDouble().booleanValue()) {
            return (Double)((BasicDoubleValue)rv).getValue();
        }
        if (rv.isJavaObject().booleanValue() && (o = ((BasicJavaObjectValue)rv).getValue()) instanceof Double) {
            return (Double)o;
        }
        if (rv == BasicEmptyValue.EMPTY_VALUE) {
            return 0.0;
        }
        throw new BasicRuntimeException("Can not convert value to double");
    }

    public String toString() {
        try {
            return "" + BasicDoubleValue.asDouble(this);
        }
        catch (BasicRuntimeException e) {
            return super.toString();
        }
    }

    @Override
    public Double getNumericValue() {
        return (Double)this.getValue();
    }
}

