/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.operators;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.operators.AbstractUnaryOperator;
import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.RightValue;

public class UnaryOperatorMinus
extends AbstractUnaryOperator {
    @Override
    public RightValue evaluate(Interpreter interpreter) throws ScriptBasicException {
        Expression operand = this.getOperand();
        RightValue rightValue = operand.evaluate(interpreter);
        AbstractNumericRightValue result = null;
        if (!rightValue.isNumeric().booleanValue()) {
            throw new BasicRuntimeException("Unary minus operator applied to non numeric value");
        }
        if (rightValue.isDouble().booleanValue()) {
            result = new BasicDoubleValue(-1.0 * (Double)((BasicDoubleValue)rightValue).getValue());
        } else if (rightValue.isLong().booleanValue()) {
            result = new BasicLongValue(-1L * (Long)((BasicLongValue)rightValue).getValue());
        }
        return result;
    }
}

