/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.expression;

import com.scriptbasic.context.Context;
import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.operators.AbstractUnaryOperator;
import com.scriptbasic.executors.operators.UnaryOperatorMinus;
import com.scriptbasic.executors.operators.UnaryOperatorNot;
import com.scriptbasic.executors.operators.UnaryOperatorPlus;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.ArrayElementAccess;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.executors.rightvalues.FunctionCall;
import com.scriptbasic.executors.rightvalues.VariableAccess;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.LineOrientedLexicalAnalyzer;
import com.scriptbasic.interfaces.TagAnalyzer;
import com.scriptbasic.syntax.AbstractAnalyzer;
import com.scriptbasic.utility.LexUtility;
import java.util.HashMap;
import java.util.Map;

public final class BasicTagAnalyzer
extends AbstractAnalyzer<Expression>
implements TagAnalyzer {
    private static final Map<String, Class<? extends AbstractUnaryOperator>> unaryOperatorMap = new HashMap<String, Class<? extends AbstractUnaryOperator>>();
    private final Context ctx;

    public BasicTagAnalyzer(Context ctx) {
        this.ctx = ctx;
    }

    private static Expression newVariableAccess(LexicalElement identifierElement) {
        VariableAccess variableAccessNode = new VariableAccess();
        variableAccessNode.setVariableName(identifierElement.getLexeme());
        return variableAccessNode;
    }

    private static AbstractPrimitiveRightValue<?> newLiteralConstant(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        LexicalElement lexicalElement = LexUtility.get(lexicalAnalyzer);
        if (lexicalElement.isDouble().booleanValue()) {
            return new BasicDoubleValue(lexicalElement.doubleValue());
        }
        if (lexicalElement.isLong().booleanValue()) {
            return new BasicLongValue(lexicalElement.longValue());
        }
        if (lexicalElement.isString().booleanValue()) {
            return new BasicStringValue(lexicalElement.stringValue());
        }
        if (lexicalElement.isBoolean().booleanValue()) {
            return new BasicBooleanValue(lexicalElement.booleanValue());
        }
        throw new BasicInterpreterInternalError("Lexical element type=" + lexicalElement.getType() + " lexeme=\"" + lexicalElement.getLexeme() + "\"");
    }

    private static boolean isParenthese(LexicalElement lexicalElement, String ch) {
        if (lexicalElement != null && lexicalElement.isSymbol().booleanValue()) {
            return ch.equals(lexicalElement.getLexeme());
        }
        return false;
    }

    private static boolean isClosingBracket(LexicalElement lexicalElement) {
        return BasicTagAnalyzer.isParenthese(lexicalElement, "]");
    }

    private static boolean isOpeningBracket(LexicalElement lexicalElement) {
        return BasicTagAnalyzer.isParenthese(lexicalElement, "[");
    }

    private static boolean isClosingParenthese(LexicalElement lexicalElement) {
        return BasicTagAnalyzer.isParenthese(lexicalElement, ")");
    }

    private static boolean isOpeningParenthese(LexicalElement lexicalElement) {
        return BasicTagAnalyzer.isParenthese(lexicalElement, "(");
    }

    private static boolean isUnaryOperator(LexicalElement lexicalElement) {
        return lexicalElement.isSymbol() != false && unaryOperatorMap.containsKey(lexicalElement.getLexeme().toLowerCase());
    }

    @Override
    public Expression analyze() throws AnalysisException {
        LineOrientedLexicalAnalyzer lexicalAnalyzer = this.ctx.lexicalAnalyzer;
        LexicalElement lexicalElement = LexUtility.peek(lexicalAnalyzer);
        if (lexicalElement != null) {
            if (BasicTagAnalyzer.isUnaryOperator(lexicalElement)) {
                return this.newUnaryOperator(lexicalAnalyzer);
            }
            if (lexicalElement.isLiteralConstant().booleanValue()) {
                return BasicTagAnalyzer.newLiteralConstant(lexicalAnalyzer);
            }
            if (BasicTagAnalyzer.isOpeningParenthese(lexicalElement)) {
                return this.newSubExpression(lexicalAnalyzer);
            }
            if (lexicalElement.isIdentifier().booleanValue()) {
                return this.newArrayOrVariableOrFunctionCall(lexicalAnalyzer);
            }
        }
        throw new BasicSyntaxException("Expression syntax is erroneous. Unexpected lexeme is " + String.valueOf(lexicalElement), lexicalElement);
    }

    private Expression newArrayOrVariableOrFunctionCall(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        LexicalElement identifierElement = LexUtility.get(lexicalAnalyzer);
        LexicalElement lexicalElement = LexUtility.peek(lexicalAnalyzer);
        if (BasicTagAnalyzer.isOpeningBracket(lexicalElement)) {
            return this.newArray(lexicalAnalyzer, identifierElement);
        }
        if (BasicTagAnalyzer.isOpeningParenthese(lexicalElement)) {
            return this.newFunctionCall(lexicalAnalyzer, identifierElement);
        }
        return BasicTagAnalyzer.newVariableAccess(identifierElement);
    }

    private Expression newFunctionCall(LexicalAnalyzer lexicalAnalyzer, LexicalElement identifierElement) throws AnalysisException {
        FunctionCall functionCall = new FunctionCall();
        LexUtility.get(lexicalAnalyzer);
        functionCall.setVariableName(identifierElement.getLexeme());
        LexicalElement lexicalElement = LexUtility.peek(lexicalAnalyzer);
        if (!BasicTagAnalyzer.isClosingParenthese(lexicalElement)) {
            functionCall.setExpressionList((ExpressionList)this.ctx.expressionListAnalyzer.analyze());
            lexicalElement = LexUtility.peek(lexicalAnalyzer);
        }
        if (BasicTagAnalyzer.isClosingParenthese(lexicalElement)) {
            LexUtility.get(lexicalAnalyzer);
            return functionCall;
        }
        throw new BasicSyntaxException("There is no closing ')' in function call.");
    }

    private Expression newArray(LexicalAnalyzer lexicalAnalyzer, LexicalElement identifierElement) throws AnalysisException {
        LexUtility.get(lexicalAnalyzer);
        ArrayElementAccess arrayElementAccess = new ArrayElementAccess();
        arrayElementAccess.setVariableName(identifierElement.getLexeme());
        arrayElementAccess.setExpressionList((ExpressionList)this.ctx.expressionListAnalyzer.analyze());
        LexicalElement lexicalElement = LexUtility.peek(lexicalAnalyzer);
        if (BasicTagAnalyzer.isClosingBracket(lexicalElement)) {
            LexUtility.get(lexicalAnalyzer);
            return arrayElementAccess;
        }
        throw new BasicSyntaxException("There is no closing ']' in array element access.");
    }

    private Expression newSubExpression(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        LexUtility.get(lexicalAnalyzer);
        Expression expression = this.ctx.expressionAnalyzer.analyze();
        LexicalElement lexicalElement = LexUtility.peek(lexicalAnalyzer);
        if (!BasicTagAnalyzer.isClosingParenthese(lexicalElement)) {
            throw new BasicSyntaxException("There is no matching closing ')' for an opening '('");
        }
        LexUtility.get(lexicalAnalyzer);
        return expression;
    }

    private AbstractUnaryOperator newUnaryOperator(LexicalAnalyzer lexicalAnalyzer) throws AnalysisException {
        AbstractUnaryOperator operator;
        LexicalElement lexicalElement = LexUtility.get(lexicalAnalyzer);
        try {
            operator = unaryOperatorMap.get(lexicalElement.getLexeme().toLowerCase()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BasicSyntaxException(e);
        }
        operator.setOperand(this.analyze());
        return operator;
    }

    static {
        unaryOperatorMap.put("+", UnaryOperatorPlus.class);
        unaryOperatorMap.put("-", UnaryOperatorMinus.class);
        unaryOperatorMap.put("not", UnaryOperatorNot.class);
    }
}

