/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.model;

import com.sigopt.model.APIObject;
import com.sigopt.model.Utils;
import java.util.Map;

public class Observation
extends APIObject {
    public Observation() {
    }

    public Observation(String id) {
        this.set("id", id);
    }

    public Boolean isFailed() {
        return (Boolean)this.get("failed");
    }

    public Double getValue() {
        return (Double)this.get("value");
    }

    public Double getValueStddev() {
        return (Double)this.get("value_stddev");
    }

    public Integer getCreated() {
        return Utils.asInteger(this.get("created"));
    }

    public Map<String, Object> getAssignments() {
        return (Map)this.get("assignments");
    }

    public Map<String, String> getMetadata() {
        return (Map)this.get("metadata");
    }

    public String getExperiment() {
        return (String)this.get("experiment");
    }

    public String getId() {
        return (String)this.get("id");
    }

    public String getSuggestion() {
        return (String)this.get("suggestion");
    }

    public static class Builder {
        Observation o = new Observation();

        public Observation build() {
            return this.o;
        }

        public Builder failed(Boolean failed) {
            this.o.set("failed", failed);
            return this;
        }

        public Builder value(Double value) {
            this.o.set("value", value);
            return this;
        }

        public Builder valueStddev(Double valueStddev) {
            this.o.set("value_stddev", valueStddev);
            return this;
        }

        public Builder created(Integer created) {
            this.o.set("created", created);
            return this;
        }

        public Builder assignments(Map<String, Object> assignments) {
            this.o.set("assignments", assignments);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.o.set("metadata", metadata);
            return this;
        }

        public Builder experiment(String experiment) {
            this.o.set("experiment", experiment);
            return this;
        }

        public Builder id(String id) {
            this.o.set("id", id);
            return this;
        }

        public Builder suggestion(String suggestion) {
            this.o.set("suggestion", suggestion);
            return this;
        }
    }
}

