/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.net;

import com.sigopt.exception.AuthenticationException;
import com.sigopt.net.MapHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

class HeadersBuilder {
    HeadersBuilder() {
    }

    public static Map<String, String> build(Map<String, String> headers) throws AuthenticationException {
        return HeadersBuilder.build(headers, null, null);
    }

    public static Map<String, String> build(Map<String, String> headers, String apiKey) throws AuthenticationException {
        return HeadersBuilder.build(headers, apiKey, null);
    }

    public static Map<String, String> build(Map<String, String> headers, String apiKey, String authKey) throws AuthenticationException {
        Map<Object, Object> ret = new HashMap();
        ret = MapHelper.merge(ret, HeadersBuilder.defaultHeaders());
        if (authKey != null && !authKey.isEmpty()) {
            ret = MapHelper.merge(ret, HeadersBuilder.customAuthHeader(authKey, apiKey));
        } else if (apiKey != null && !apiKey.isEmpty()) {
            ret = MapHelper.merge(ret, HeadersBuilder.basicAuthHeader(apiKey));
        }
        if (headers != null) {
            ret.putAll(headers);
        }
        return ret;
    }

    public static Map<String, String> defaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String userAgent = "Sigopt/v1 JavaBindings/2.3.2";
        headers.put("User-Agent", userAgent);
        return headers;
    }

    public static Map<String, String> customAuthHeader(String authKey, String apiKey) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(authKey, apiKey);
        return ret;
    }

    public static Map<String, String> basicAuthHeader(String apiKey) throws AuthenticationException {
        if (apiKey == null) {
            throw new AuthenticationException("An API key is required but was never set. Please see https://sigopt.com/docs for more information.");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        byte[] apiKeyBytes = String.format("%s:", apiKey).getBytes();
        String base64Key = new String(Base64.encodeBase64((byte[])apiKeyBytes));
        ret.put("Authorization", "Basic " + base64Key);
        return ret;
    }
}

