/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.process;

import com.simtechdata.process.OutputConsumptionThread;
import com.simtechdata.process.StreamCopyRunner;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

class IoHandler {
    private final OutputConsumptionThread stdout;
    private final OutputConsumptionThread stderr;
    Thread inFeeder;

    IoHandler(InputStream stdin, OutputConsumptionThread stdout, OutputConsumptionThread stderr, Process process) {
        this.stdout = stdout;
        this.stderr = stderr;
        InputStream out = process.getInputStream();
        InputStream err = process.getErrorStream();
        OutputStream in = process.getOutputStream();
        stdout.startConsumption(out);
        stderr.startConsumption(err);
        this.inFeeder = this.startConsumption(in, stdin);
    }

    List<Throwable> joinConsumption() throws InterruptedException {
        this.inFeeder.join();
        this.stdout.join();
        this.stderr.join();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        if (this.stdout.getThrowable() != null) {
            exceptions.add(this.stdout.getThrowable());
        }
        if (this.stderr.getThrowable() != null) {
            exceptions.add(this.stderr.getThrowable());
        }
        return exceptions;
    }

    void cancelConsumption() {
        this.inFeeder.interrupt();
        this.stdout.interrupt();
        this.stderr.interrupt();
    }

    Thread startConsumption(OutputStream stdout, InputStream out) {
        Thread consumer = new Thread(new StreamCopyRunner(out, stdout, true));
        consumer.start();
        return consumer;
    }
}

