/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.client;

import com.sitewhere.rest.client.AuthenticationRetrofit;
import com.sitewhere.rest.client.Base64;
import com.sitewhere.rest.client.SiteWhereRestRetrofit;
import com.sitewhere.rest.client.TenantAuthentication;
import com.sitewhere.rest.model.area.Area;
import com.sitewhere.rest.model.area.Zone;
import com.sitewhere.rest.model.area.request.AreaCreateRequest;
import com.sitewhere.rest.model.area.request.ZoneCreateRequest;
import com.sitewhere.rest.model.batch.BatchOperation;
import com.sitewhere.rest.model.common.MetadataProvider;
import com.sitewhere.rest.model.datatype.JsonDateSerializer;
import com.sitewhere.rest.model.device.Device;
import com.sitewhere.rest.model.device.DeviceAssignment;
import com.sitewhere.rest.model.device.DeviceType;
import com.sitewhere.rest.model.device.command.DeviceCommand;
import com.sitewhere.rest.model.device.event.DeviceAlert;
import com.sitewhere.rest.model.device.event.DeviceCommandInvocation;
import com.sitewhere.rest.model.device.event.DeviceEventBatch;
import com.sitewhere.rest.model.device.event.DeviceEventBatchResponse;
import com.sitewhere.rest.model.device.event.DeviceLocation;
import com.sitewhere.rest.model.device.event.DeviceMeasurement;
import com.sitewhere.rest.model.device.event.request.DeviceAlertCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceCommandInvocationCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceLocationCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceMeasurementCreateRequest;
import com.sitewhere.rest.model.device.group.DeviceGroup;
import com.sitewhere.rest.model.device.request.DeviceCommandCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceGroupCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceGroupElementCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceStreamCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceTypeCreateRequest;
import com.sitewhere.rest.model.device.streaming.DeviceStream;
import com.sitewhere.rest.model.search.AssetSearchResults;
import com.sitewhere.rest.model.search.DateRangeSearchCriteria;
import com.sitewhere.rest.model.search.DeviceAlertSearchResults;
import com.sitewhere.rest.model.search.DeviceAssignmentSearchResults;
import com.sitewhere.rest.model.search.DeviceCommandInvocationSearchResults;
import com.sitewhere.rest.model.search.DeviceCommandSearchResults;
import com.sitewhere.rest.model.search.DeviceGroupElementSearchResults;
import com.sitewhere.rest.model.search.DeviceGroupSearchResults;
import com.sitewhere.rest.model.search.DeviceLocationSearchResults;
import com.sitewhere.rest.model.search.DeviceSearchResults;
import com.sitewhere.rest.model.search.DeviceStreamSearchResults;
import com.sitewhere.rest.model.search.DeviceTypeSearchResults;
import com.sitewhere.rest.model.search.SearchCriteria;
import com.sitewhere.rest.model.search.SearchResults;
import com.sitewhere.rest.model.search.ZoneSearchResults;
import com.sitewhere.rest.model.system.Version;
import com.sitewhere.spi.ISiteWhereClient;
import com.sitewhere.spi.ITenantAuthentication;
import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.device.DeviceAssignmentStatus;
import com.sitewhere.spi.device.event.IDeviceMeasurement;
import com.sitewhere.spi.device.request.IDeviceAssignmentCreateRequest;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class SiteWhereClient
implements ISiteWhereClient {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final String AUTH_RELATIVE_URL = "/sitewhere/authapi/";
    public static final String REST_RELATIVE_URL = "/sitewhere/api/";
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "password";
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private String protocol = "http";
    private String hostname = "localhost";
    private int port = 8080;
    private String username = "admin";
    private String password = "password";
    private int connectTimeout = 3000;
    private AuthenticationRetrofit authRetrofit;
    private SiteWhereRestRetrofit restRetrofit;
    private String jwt;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Version getSiteWhereVersion() throws SiteWhereException {
        Call<Version> call = this.getRestRetrofit().getVersion();
        return this.processRestCall(call);
    }

    @Override
    public DeviceType createDeviceType(ITenantAuthentication tenant, DeviceTypeCreateRequest request) throws SiteWhereException {
        Call<DeviceType> call = this.getRestRetrofit().createDeviceType(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceType getDeviceTypeByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceType> call = this.getRestRetrofit().getDeviceTypeByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceType updateDeviceType(ITenantAuthentication tenant, String token, DeviceTypeCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceTypeSearchResults listDeviceTypes(boolean includeDeleted, boolean includeDetailedAssetInfo, SearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceType deleteDeviceType(String token, boolean deletePermanently) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceCommand createDeviceCommand(String specificationToken, DeviceCommandCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceCommandSearchResults listDeviceCommands(String specificationToken, boolean includeDeleted) throws SiteWhereException {
        return null;
    }

    @Override
    public Area createArea(AreaCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public Area getAreaByToken(String token) throws SiteWhereException {
        return null;
    }

    @Override
    public Zone createZone(String siteToken, ZoneCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public ZoneSearchResults listZonesForSite(String siteToken) throws SiteWhereException {
        return null;
    }

    @Override
    public Device createDevice(DeviceCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public Device getDeviceByHardwareId(String hardwareId) throws SiteWhereException {
        return null;
    }

    @Override
    public Device updateDevice(String hardwareId, DeviceCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceSearchResults listDevices(boolean includeDeleted, boolean excludeAssigned, boolean populateSpecification, boolean populateAssignment, DateRangeSearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public Device deleteDevice(String hardwareId, boolean force) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignment getCurrentAssignmentForDevice(String hardwareId) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignmentSearchResults listDeviceAssignmentHistory(String hardwareId) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignmentSearchResults getAssignmentsForAsset(String siteToken, String assetModuleId, String assetId, DeviceAssignmentStatus status, SearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceEventBatchResponse addDeviceEventBatch(String hardwareId, DeviceEventBatch batch) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignment createDeviceAssignment(IDeviceAssignmentCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignment getDeviceAssignmentByToken(String assignmentToken) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignmentSearchResults listAssignmentsForSite(String token) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignment deleteDeviceAssignment(String assignmentToken, boolean force) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAssignment updateDeviceAssignmentMetadata(String token, MetadataProvider metadata) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceMeasurement createDeviceMeasurements(String assignmentToken, DeviceMeasurementCreateRequest measurements) throws SiteWhereException {
        return null;
    }

    @Override
    public SearchResults<IDeviceMeasurement> listDeviceMeasurements(String assignmentToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceLocation createDeviceLocation(String assignmentToken, DeviceLocationCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceLocationSearchResults listDeviceLocations(String assignmentToken, DateRangeSearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAlert createDeviceAlert(String assignmentToken, DeviceAlertCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceAlertSearchResults listDeviceAlerts(String assignmentToken, DateRangeSearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceCommandInvocation createDeviceCommandInvocation(String assignmentToken, DeviceCommandInvocationCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceCommandInvocationSearchResults listDeviceCommandInvocations(String assignmentToken, DateRangeSearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceStream createDeviceStream(String assignmentToken, DeviceStreamCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceStream getDeviceStream(String assignmentToken, String streamId) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceStreamSearchResults listDeviceStreams(String assignmentToken, DateRangeSearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public void addDeviceStreamData(String assignmentToken, String streamId, long sequenceNumber, byte[] data) throws SiteWhereException {
    }

    @Override
    public byte[] getDeviceStreamData(String assignmentToken, String streamId, long sequenceNumber) throws SiteWhereException {
        return null;
    }

    @Override
    public byte[] listDeviceStreamData(String assignmentToken, String streamId, DateRangeSearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public BatchOperation createBatchCommandInvocation(String batchToken, String commandToken, Map<String, String> parameters, List<String> hardwareIds) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroup createDeviceGroup(DeviceGroupCreateRequest request) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroup getDeviceGroupByToken(String token) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroup deleteDeviceGroup(String token) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroupSearchResults listDeviceGroups(String role, SearchCriteria criteria, boolean includeDeleted) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroupElementSearchResults addDeviceGroupElements(String groupToken, List<DeviceGroupElementCreateRequest> elements) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroupElementSearchResults listDeviceGroupElements(String groupToken, boolean includeDetails, SearchCriteria criteria) throws SiteWhereException {
        return null;
    }

    @Override
    public DeviceGroupElementSearchResults deleteDeviceGroupElements(String groupToken, List<DeviceGroupElementCreateRequest> elements) throws SiteWhereException {
        return null;
    }

    @Override
    public AssetSearchResults getAssetsByModuleId(String moduleId, String criteria) throws SiteWhereException {
        return null;
    }

    public static ITenantAuthentication defaultTenant() {
        TenantAuthentication auth = new TenantAuthentication();
        auth.setTenantToken("default");
        auth.setTenantAuthToken("sitewhere1234567890");
        return auth;
    }

    public static ITenantAuthentication forTenant(String tenantToken, String tenantAuthToken) {
        TenantAuthentication auth = new TenantAuthentication();
        auth.setTenantToken(tenantToken);
        auth.setTenantAuthToken(tenantAuthToken);
        return auth;
    }

    protected <T> T processRestCall(Call<T> call) throws SiteWhereException {
        try {
            retrofit2.Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            throw new SiteWhereException(response.toString());
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public ISiteWhereClient initialize() throws SiteWhereException {
        Retrofit authRetrofitSettings = new Retrofit.Builder().baseUrl(this.getAuthApiUrl()).client(this.buildBasicAuthClient()).build();
        this.authRetrofit = (AuthenticationRetrofit)authRetrofitSettings.create(AuthenticationRetrofit.class);
        Retrofit restRetrofitSettings = new Retrofit.Builder().baseUrl(this.getRestApiUrl()).client(this.buildGlobalClient()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.restRetrofit = (SiteWhereRestRetrofit)restRetrofitSettings.create(SiteWhereRestRetrofit.class);
        try {
            retrofit2.Response jwtResponse = this.getAuthRetrofit().getJwt().execute();
            if (!jwtResponse.isSuccessful()) {
                throw new SiteWhereException("Error obtaining JWT: " + jwtResponse);
            }
            Headers headers = jwtResponse.headers();
            List jwts = headers.values("X-Sitewhere-JWT");
            if (jwts.size() <= 0) {
                throw new SiteWhereException("No JWT returned in server response.");
            }
            this.jwt = (String)jwts.get(0);
            return this;
        }
        catch (IOException e) {
            throw new SiteWhereException("Exception obtaining JWT.", (Throwable)e);
        }
    }

    protected OkHttpClient buildBasicAuthClient() {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", SiteWhereClient.this.getAuthHeader());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
        return httpClient.build();
    }

    protected OkHttpClient buildGlobalClient() {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", "Bearer " + SiteWhereClient.this.jwt);
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
        return httpClient.build();
    }

    protected Map<String, String> createHeadersFor(ITenantAuthentication tenant) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-SiteWhere-Tenant-Id", tenant.getTenantToken());
        headers.put("X-SiteWhere-Tenant-Auth", tenant.getTenantAuthToken());
        return headers;
    }

    protected String getSearchCriteriaFields(SearchCriteria criteria) {
        String result = "page={page}&pageSize={pageSize}";
        if (criteria instanceof DateRangeSearchCriteria) {
            DateRangeSearchCriteria dates = (DateRangeSearchCriteria)criteria;
            if (dates.getStartDate() != null) {
                result = result + "&startDate={startDate}";
            }
            if (dates.getEndDate() != null) {
                result = result + "&endDate={endDate}";
            }
        }
        return result;
    }

    protected void addSearchCriteria(Map<String, String> vars, SearchCriteria criteria) {
        if (criteria != null) {
            if (criteria.getPageNumber() != null) {
                vars.put("page", String.valueOf(criteria.getPageNumber()));
            }
            if (criteria.getPageSize() != null) {
                vars.put("pageSize", String.valueOf(criteria.getPageSize()));
            }
        }
        if (criteria instanceof DateRangeSearchCriteria) {
            DateRangeSearchCriteria dates = (DateRangeSearchCriteria)criteria;
            if (dates.getStartDate() != null) {
                vars.put("startDate", JsonDateSerializer.serialize((Date)dates.getStartDate()));
            }
            if (dates.getEndDate() != null) {
                vars.put("endDate", JsonDateSerializer.serialize((Date)dates.getEndDate()));
            }
        }
    }

    protected String getRestApiUrl() {
        return this.getProtocol() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort()) + REST_RELATIVE_URL;
    }

    protected String getAuthApiUrl() {
        return this.getProtocol() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort()) + AUTH_RELATIVE_URL;
    }

    protected String getAuthHeader() {
        String token = this.getUsername() + ":" + this.getPassword();
        String encoded = new String(Base64.encode(token.getBytes()));
        return "Basic " + encoded;
    }

    public AuthenticationRetrofit getAuthRetrofit() {
        return this.authRetrofit;
    }

    public void setAuthRetrofit(AuthenticationRetrofit authRetrofit) {
        this.authRetrofit = authRetrofit;
    }

    public SiteWhereRestRetrofit getRestRetrofit() {
        return this.restRetrofit;
    }

    public void setRestRetrofit(SiteWhereRestRetrofit restRetrofit) {
        this.restRetrofit = restRetrofit;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public static class Builder {
        private SiteWhereClient client = new SiteWhereClient();

        public ISiteWhereClient build() {
            return this.client;
        }

        public Builder withConnectionTo(String protocol, String hostname, int port) {
            this.client.setProtocol(protocol);
            this.client.setHostname(hostname);
            this.client.setPort(port);
            return this;
        }

        public Builder forUser(String username, String password) {
            this.client.setUsername(username);
            this.client.setPassword(password);
            return this;
        }
    }
}

