/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.client;

import com.sitewhere.rest.model.area.Area;
import com.sitewhere.rest.model.area.AreaType;
import com.sitewhere.rest.model.area.Zone;
import com.sitewhere.rest.model.area.request.AreaCreateRequest;
import com.sitewhere.rest.model.area.request.AreaTypeCreateRequest;
import com.sitewhere.rest.model.area.request.ZoneCreateRequest;
import com.sitewhere.rest.model.asset.Asset;
import com.sitewhere.rest.model.asset.AssetType;
import com.sitewhere.rest.model.asset.marshaling.MarshaledAsset;
import com.sitewhere.rest.model.asset.request.AssetCreateRequest;
import com.sitewhere.rest.model.asset.request.AssetTypeCreateRequest;
import com.sitewhere.rest.model.batch.BatchElement;
import com.sitewhere.rest.model.batch.BatchOperation;
import com.sitewhere.rest.model.batch.request.BatchCommandForCriteriaRequest;
import com.sitewhere.rest.model.batch.request.BatchCommandInvocationRequest;
import com.sitewhere.rest.model.customer.Customer;
import com.sitewhere.rest.model.customer.CustomerType;
import com.sitewhere.rest.model.customer.request.CustomerCreateRequest;
import com.sitewhere.rest.model.customer.request.CustomerTypeCreateRequest;
import com.sitewhere.rest.model.device.Device;
import com.sitewhere.rest.model.device.DeviceElementMapping;
import com.sitewhere.rest.model.device.DeviceStatus;
import com.sitewhere.rest.model.device.DeviceType;
import com.sitewhere.rest.model.device.asset.DeviceAlertWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceCommandResponseWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceEventWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceLocationWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceMeasurementWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceStateChangeWithAsset;
import com.sitewhere.rest.model.device.charting.ChartSeries;
import com.sitewhere.rest.model.device.command.DeviceCommand;
import com.sitewhere.rest.model.device.command.DeviceCommandNamespace;
import com.sitewhere.rest.model.device.event.DeviceCommandInvocation;
import com.sitewhere.rest.model.device.event.DeviceCommandResponse;
import com.sitewhere.rest.model.device.event.DeviceEventBatch;
import com.sitewhere.rest.model.device.event.DeviceEventBatchResponse;
import com.sitewhere.rest.model.device.event.request.DeviceAlertCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceCommandInvocationCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceCommandResponseCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceLocationCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceMeasurementCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceStateChangeCreateRequest;
import com.sitewhere.rest.model.device.event.view.DeviceCommandInvocationSummary;
import com.sitewhere.rest.model.device.group.DeviceGroup;
import com.sitewhere.rest.model.device.group.DeviceGroupElement;
import com.sitewhere.rest.model.device.marshaling.MarshaledArea;
import com.sitewhere.rest.model.device.marshaling.MarshaledAreaType;
import com.sitewhere.rest.model.device.marshaling.MarshaledCustomer;
import com.sitewhere.rest.model.device.marshaling.MarshaledDevice;
import com.sitewhere.rest.model.device.marshaling.MarshaledDeviceAssignment;
import com.sitewhere.rest.model.device.request.DeviceAssignmentBulkRequest;
import com.sitewhere.rest.model.device.request.DeviceAssignmentCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceCommandCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceGroupCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceGroupElementCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceStatusCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceTypeCreateRequest;
import com.sitewhere.rest.model.device.state.DeviceState;
import com.sitewhere.rest.model.scheduling.Schedule;
import com.sitewhere.rest.model.scheduling.ScheduledJob;
import com.sitewhere.rest.model.scheduling.request.ScheduleCreateRequest;
import com.sitewhere.rest.model.scheduling.request.ScheduledJobCreateRequest;
import com.sitewhere.rest.model.search.SearchResults;
import com.sitewhere.rest.model.search.TreeNode;
import com.sitewhere.rest.model.search.device.DeviceStateSearchCriteria;
import com.sitewhere.rest.model.system.Version;
import com.sitewhere.rest.model.tenant.Tenant;
import com.sitewhere.rest.model.tenant.request.TenantCreateRequest;
import com.sitewhere.rest.model.user.GrantedAuthority;
import com.sitewhere.rest.model.user.GrantedAuthorityHierarchyNode;
import com.sitewhere.rest.model.user.User;
import com.sitewhere.rest.model.user.request.GrantedAuthorityCreateRequest;
import com.sitewhere.rest.model.user.request.UserCreateRequest;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HeaderMap;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface SiteWhereRestRetrofit {
    @GET(value="areatypes")
    public Call<SearchResults<AreaType>> listAreaTypes(@Query(value="includeContainedAreaTypes") Boolean var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="areatypes/{areaTypeToken}")
    public Call<MarshaledAreaType> getAreaTypeByToken(@Path(value="areaTypeToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="areatypes")
    public Call<AreaType> createAreaType(@Body AreaTypeCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="areatypes/{areaTypeToken}")
    public Call<AreaType> updateAreaType(@Path(value="areaTypeToken") String var1, @Body AreaTypeCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="areatypes/{areaTypeToken}")
    public Call<AreaType> deleteAreaType(@Path(value="areaTypeToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="areatypes/{areaTypeToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForAreaType(@Path(value="areaTypeToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="areas")
    public Call<SearchResults<Area>> listAreas(@Query(value="areaTypeToken") String var1, @Query(value="includeAreaType") Boolean var2, @Query(value="includeAssignments") Boolean var3, @Query(value="includeZones") Boolean var4, @Query(value="page") Integer var5, @Query(value="pageSize") Integer var6, @Query(value="parentAreaToken") String var7, @Query(value="rootOnly") Boolean var8, @HeaderMap Map<String, String> var9);

    @GET(value="areas/{areaToken}")
    public Call<MarshaledArea> getAreaByToken(@Path(value="areaToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="areas")
    public Call<Area> createArea(@Body AreaCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="areas/{areaToken}")
    public Call<Area> updateArea(@Path(value="areaToken") String var1, @Body AreaCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="areas/{areaToken}")
    public Call<Area> deleteArea(@Path(value="areaToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="areas/{areaToken}/alerts")
    public Call<SearchResults<DeviceAlertWithAsset>> listAlertsForArea(@Path(value="areaToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="areas/{areaToken}/assignments")
    public Call<SearchResults<MarshaledDeviceAssignment>> listDeviceAssignmentsForArea(@Path(value="areaToken") String var1, @Query(value="status") String var2, @Query(value="includeDevice") Boolean var3, @Query(value="includeCustomer") Boolean var4, @Query(value="includeArea") Boolean var5, @Query(value="includeAsset") Boolean var6, @Query(value="page") Integer var7, @Query(value="pageSize") Integer var8, @HeaderMap Map<String, String> var9);

    @GET(value="areas/{areaToken}/invocations")
    public Call<SearchResults<DeviceCommandInvocation>> listCommandInvocationsForArea(@Path(value="areaToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="areas/{areaToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForArea(@Path(value="areaToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="areas/{areaToken}/locations")
    public Call<SearchResults<DeviceLocationWithAsset>> listLocationsForArea(@Path(value="areaToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="areas/{areaToken}/measurements")
    public Call<SearchResults<DeviceMeasurementWithAsset>> listMeasurementsForArea(@Path(value="areaToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="areas/{areaToken}/responses")
    public Call<SearchResults<DeviceCommandResponseWithAsset>> listCommandResponsesForArea(@Path(value="areaToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="areas/{areaToken}/statechanges")
    public Call<SearchResults<DeviceStateChangeWithAsset>> listStateChangesForArea(@Path(value="areaToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="areas/tree")
    public Call<List<TreeNode>> areaTree(@HeaderMap Map<String, String> var1);

    @GET(value="assettypes")
    public Call<SearchResults<AssetType>> listAssetTypes(@Query(value="page") Integer var1, @Query(value="pageSize") Integer var2, @HeaderMap Map<String, String> var3);

    @GET(value="assettypes/{assetTypeToken}")
    public Call<AssetType> getAssetTypeByToken(@Path(value="assetTypeToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="assettypes")
    public Call<AssetType> createAssetType(@Body AssetTypeCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="assettypes/{assetTypeToken}")
    public Call<AssetType> updateAssetType(@Path(value="assetTypeToken") String var1, @Body AssetTypeCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="assettypes/{assetTypeToken}")
    public Call<AssetType> deleteAssetType(@Path(value="assetTypeToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="assettypes/{assetTypeToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForAssetType(@Path(value="assetTypeToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="assets")
    public Call<SearchResults<Asset>> listAssets(@Query(value="assetTypeToken") String var1, @Query(value="includeAssetType") Boolean var2, @Query(value="page") Integer var3, @Query(value="pageSize") Integer var4, @HeaderMap Map<String, String> var5);

    @GET(value="assets/{assetToken}")
    public Call<MarshaledAsset> getAssetByToken(@Path(value="assetToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="assets")
    public Call<Asset> createAsset(@Body AssetCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="assets/{assetToken}")
    public Call<Asset> updateAsset(@Path(value="assetToken") String var1, @Body AssetCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="assets/{assetToken}")
    public Call<Asset> deleteAsset(@Path(value="assetToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="assets/{assetToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForAsset(@Path(value="assetToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="assignments")
    public Call<SearchResults<MarshaledDeviceAssignment>> listDeviceAssignments(@Query(value="areaToken") String var1, @Query(value="includeArea") Boolean var2, @Query(value="assetToken") String var3, @Query(value="includeAsset") Boolean var4, @Query(value="customerToken") String var5, @Query(value="includeCustomer") Boolean var6, @Query(value="deviceToken") String var7, @Query(value="includeDevice") Boolean var8, @Query(value="page") Integer var9, @Query(value="pageSize") Integer var10, @HeaderMap Map<String, String> var11);

    @GET(value="assignments/{token}")
    public Call<MarshaledDeviceAssignment> getDeviceAssignmentByToken(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments")
    public Call<MarshaledDeviceAssignment> createDeviceAssignment(@Body DeviceAssignmentCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="assignments/{token}")
    public Call<MarshaledDeviceAssignment> updateDeviceAssignment(@Path(value="token") String var1, @Body DeviceAssignmentCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="assignments/{token}")
    public Call<MarshaledDeviceAssignment> deleteDeviceAssignment(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="assignments/{token}/alerts")
    public Call<SearchResults<DeviceAlertWithAsset>> listAlertsForDeviceAssignment(@Path(value="token") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @POST(value="assignments/{token}/alerts")
    public Call<DeviceAlertWithAsset> createAlertForDeviceAssignment(@Path(value="token") String var1, @Body DeviceAlertCreateRequest var2, @HeaderMap Map<String, String> var3);

    @POST(value="assignments/{token}/end")
    public Call<MarshaledDeviceAssignment> releaseDeviceAssignment(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="assignments/{token}/invocations")
    public Call<SearchResults<DeviceCommandInvocation>> listCommandInvocationsForDeviceAssignment(@Path(value="token") String var1, @Query(value="includeCommand") Boolean var2, @Query(value="startDate") String var3, @Query(value="endDate") String var4, @Query(value="page") Integer var5, @Query(value="pageSize") Integer var6, @HeaderMap Map<String, String> var7);

    @POST(value="assignments/{token}/invocations")
    public Call<DeviceCommandInvocation> createCommandInvocationForDeviceAssignment(@Path(value="token") String var1, @Body DeviceCommandInvocationCreateRequest var2, @HeaderMap Map<String, String> var3);

    @POST(value="assignments/{token}/invocations/schedules/{scheduleToken}")
    public Call<ScheduledJob> scheduleCommandInvocation(@Path(value="token") String var1, @Path(value="scheduleToken") String var2, @Body DeviceCommandInvocationCreateRequest var3, @HeaderMap Map<String, String> var4);

    @GET(value="assignments/{token}/label/{generatorId}")
    public Call<ResponseBody> getLabelForDeviceAssignment(@Path(value="token") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="assignments/{token}/locations")
    public Call<SearchResults<DeviceLocationWithAsset>> listLocationsForDeviceAssignment(@Path(value="token") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @POST(value="assignments/{token}/locations")
    public Call<DeviceLocationWithAsset> createLocationForDeviceAssignment(@Path(value="token") String var1, @Body DeviceLocationCreateRequest var2, @HeaderMap Map<String, String> var3);

    @GET(value="assignments/{token}/measurements")
    public Call<SearchResults<DeviceMeasurementWithAsset>> listMeasurementsForDeviceAssignment(@Path(value="token") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @POST(value="assignments/{token}/measurements")
    public Call<DeviceMeasurementWithAsset> createMeasurementForDeviceAssignment(@Path(value="token") String var1, @Body DeviceMeasurementCreateRequest var2, @HeaderMap Map<String, String> var3);

    @GET(value="assignments/{token}/measurements/series")
    public Call<List<ChartSeries<Double>>> listMeasurementsForDeviceAssignmentAsChartSeries(@Path(value="token") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @POST(value="assignments/{token}/missing")
    public Call<MarshaledDeviceAssignment> markMissingDeviceAssignment(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="assignments/{token}/responses")
    public Call<SearchResults<DeviceCommandResponseWithAsset>> listCommandResponsesForDeviceAssignment(@Path(value="token") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @POST(value="assignments/{token}/responses")
    public Call<DeviceCommandResponseWithAsset> createCommandResponseForDeviceAssignment(@Path(value="token") String var1, @Body DeviceCommandResponseCreateRequest var2, @HeaderMap Map<String, String> var3);

    @GET(value="assignments/{token}/statechanges")
    public Call<SearchResults<DeviceStateChangeWithAsset>> listStateChangesForDeviceAssignment(@Path(value="token") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @POST(value="assignments/{token}/statechanges")
    public Call<DeviceStateChangeWithAsset> createStateChangeForDeviceAssignment(@Path(value="token") String var1, @Body DeviceStateChangeCreateRequest var2, @HeaderMap Map<String, String> var3);

    @POST(value="assignments/bulk/alerts")
    public Call<SearchResults<DeviceAlertWithAsset>> bulkListAlertsForDeviceAssignments(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments/bulk/invocations")
    public Call<SearchResults<DeviceCommandInvocation>> bulkListCommandInvocationsForDeviceAssignments(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments/bulk/locations")
    public Call<SearchResults<DeviceLocationWithAsset>> bulkListLocationsForDeviceAssignments(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments/bulk/measurements")
    public Call<SearchResults<DeviceMeasurementWithAsset>> bulkListMeasurementsForDeviceAssignments(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments/bulk/measurements/series")
    public Call<Map<String, List<ChartSeries<Double>>>> bulkListMeasurementsForDeviceAssignmentsAsChartSeries(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments/bulk/responses")
    public Call<SearchResults<DeviceCommandResponseWithAsset>> bulkListCommandResponsesForDeviceAssignments(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="assignments/bulk/statechanges")
    public Call<SearchResults<DeviceStateChangeWithAsset>> bulkListStateChangesForDeviceAssignments(@Body DeviceAssignmentBulkRequest var1, @HeaderMap Map<String, String> var2);

    @GET(value="authorities")
    public Call<SearchResults<GrantedAuthority>> listAuthorities(@HeaderMap Map<String, String> var1);

    @POST(value="authorities")
    public Call<GrantedAuthority> createAuthority(@Body GrantedAuthorityCreateRequest var1, @HeaderMap Map<String, String> var2);

    @GET(value="authorities/{name}")
    public Call<GrantedAuthority> getAuthorityByName(@Path(value="name") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="authorities/hierarchy")
    public Call<List<GrantedAuthorityHierarchyNode>> getAuthoritiesHierarchy(@HeaderMap Map<String, String> var1);

    @GET(value="batch")
    public Call<SearchResults<BatchOperation>> listBatchOperations(@Query(value="page") Integer var1, @Query(value="pageSize") Integer var2, @HeaderMap Map<String, String> var3);

    @GET(value="batch/{batchToken}")
    public Call<BatchOperation> getBatchOperationByToken(@Path(value="batchToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="batch/{operationToken}/elements")
    public Call<SearchResults<BatchElement>> listBatchOperationElements(@Path(value="operationToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="batch/command")
    public Call<BatchOperation> createBatchCommandInvocation(@Body BatchCommandInvocationRequest var1, @HeaderMap Map<String, String> var2);

    @POST(value="batch/command/criteria")
    public Call<Object> createBatchCommandOperationForCriteria(@Body BatchCommandForCriteriaRequest var1, @HeaderMap Map<String, String> var2);

    @GET(value="invocations/id/{id}")
    public Call<DeviceCommandInvocation> getDeviceCommandInvocation(@Path(value="id") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="invocations/id/{id}/summary")
    public Call<DeviceCommandInvocationSummary> getDeviceCommandInvocationSummary(@Path(value="id") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="invocations/id/{invocationId}/responses")
    public Call<SearchResults<DeviceCommandResponse>> listCommandResponsesForCommandInvocation(@Path(value="invocationId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="customertypes")
    public Call<SearchResults<CustomerType>> listCustomerTypes(@Query(value="includeContainedCustomerTypes") Boolean var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="customertypes/{customerTypeToken}")
    public Call<CustomerType> getCustomerTypeByToken(@Path(value="customerTypeToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="customertypes")
    public Call<CustomerType> createCustomerType(@Body CustomerTypeCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="customertypes/{customerTypeToken}")
    public Call<CustomerType> updateCustomerType(@Path(value="customerTypeToken") String var1, @Body CustomerTypeCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="customertypes/{customerTypeToken}")
    public Call<CustomerType> deleteCustomerType(@Path(value="customerTypeToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="customertypes/{customerTypeToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForCustomerType(@Path(value="customerTypeToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="customers")
    public Call<SearchResults<Customer>> listCustomers(@Query(value="customerTypeToken") String var1, @Query(value="parentCustomerToken") String var2, @Query(value="page") Integer var3, @Query(value="pageSize") Integer var4, @Query(value="includeCustomerType") Boolean var5, @Query(value="rootOnly") Boolean var6, @HeaderMap Map<String, String> var7);

    @GET(value="customers/{customerToken}")
    public Call<MarshaledCustomer> getCustomerByToken(@Path(value="customerToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="customers")
    public Call<Customer> createCustomer(@Body CustomerCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="customers/{customerToken}")
    public Call<Customer> updateCustomer(@Path(value="customerToken") String var1, @Body CustomerCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="customers/{customerToken}")
    public Call<Customer> deleteCustomer(@Path(value="customerToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="customers/{customerToken}/alerts")
    public Call<SearchResults<DeviceAlertWithAsset>> listAlertsForCustomer(@Path(value="customerToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="customers/{customerToken}/assignments")
    public Call<SearchResults<MarshaledDeviceAssignment>> listDeviceAssignmentsForCustomer(@Path(value="customerToken") String var1, @Query(value="status") String var2, @Query(value="includeDevice") Boolean var3, @Query(value="includeCustomer") Boolean var4, @Query(value="includeArea") Boolean var5, @Query(value="includeAsset") Boolean var6, @Query(value="page") Integer var7, @Query(value="pageSize") Integer var8, @HeaderMap Map<String, String> var9);

    @GET(value="customers/{customerToken}/invocations")
    public Call<SearchResults<DeviceCommandInvocation>> listCommandInvocationsForCustomer(@Path(value="customerToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="customers/{customerToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForCustomer(@Path(value="customerToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="customers/{customerToken}/locations")
    public Call<SearchResults<DeviceLocationWithAsset>> listLocationsForCustomer(@Path(value="customerToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="customers/{customerToken}/measurements")
    public Call<SearchResults<DeviceMeasurementWithAsset>> listMeasurementsForCustomer(@Path(value="customerToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="customers/{customerToken}/responses")
    public Call<SearchResults<DeviceCommandResponseWithAsset>> listCommandResponsesForCustomer(@Path(value="customerToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="customers/{customerToken}/statechanges")
    public Call<SearchResults<DeviceStateChangeWithAsset>> listStateChangesForCustomer(@Path(value="customerToken") String var1, @Query(value="startDate") String var2, @Query(value="endDate") String var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="customers/tree")
    public Call<List<TreeNode>> customerTree(@HeaderMap Map<String, String> var1);

    @GET(value="commands")
    public Call<SearchResults<DeviceCommand>> listDeviceCommands(@Query(value="deviceTypeToken") String var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="commands/{token}")
    public Call<DeviceCommand> getDeviceCommandByToken(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="commands")
    public Call<DeviceCommand> createDeviceCommand(@Body DeviceCommandCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="commands/{token}")
    public Call<DeviceCommand> updateDeviceCommand(@Path(value="token") String var1, @Body DeviceCommandCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="commands/{token}")
    public Call<DeviceCommand> deleteDeviceCommand(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="commands/namespaces")
    public Call<SearchResults<DeviceCommandNamespace>> listDeviceCommandsByNamesapce(@Query(value="deviceTypeToken") String var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="events/alternate/{alternateId}")
    public Call<DeviceEventWithAsset> getDeviceEventByAlternateId(@Path(value="alternateId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="events/id/{eventId}")
    public Call<DeviceEventWithAsset> getDeviceEventById(@Path(value="eventId") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devicegroups")
    public Call<SearchResults<DeviceGroup>> listDeviceGroups(@Query(value="role") String var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="devicegroups/{groupToken}")
    public Call<DeviceGroup> getDeviceGroupByToken(@Path(value="groupToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="devicegroups")
    public Call<DeviceGroup> createDeviceGroup(@Body DeviceGroupCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="devicegroups/{groupToken}")
    public Call<DeviceGroup> updateDeviceGroup(@Path(value="groupToken") String var1, @Body DeviceGroupCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="devicegroups/{groupToken}")
    public Call<DeviceGroup> deleteDeviceGroup(@Path(value="groupToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devicegroups/{groupToken}/elements")
    public Call<SearchResults<DeviceGroupElement>> listDeviceGroupElements(@Path(value="groupToken") String var1, @Query(value="includeDetails") Boolean var2, @Query(value="page") Integer var3, @Query(value="pageSize") Integer var4, @HeaderMap Map<String, String> var5);

    @PUT(value="devicegroups/{groupToken}/elements")
    public Call<SearchResults<DeviceGroupElement>> addElementsToDdeviceGroup(@Path(value="groupToken") String var1, @Body List<DeviceGroupElementCreateRequest> var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="devicegroups/{groupToken}/elements")
    public Call<SearchResults<DeviceGroupElement>> deleteDeviceGroupElements(@Path(value="groupToken") String var1, @Body List<String> var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="devicegroups/{groupToken}/elements/{elementId}")
    public Call<SearchResults<DeviceGroupElement>> deleteDeviceGroupElement(@Path(value="groupToken") String var1, @Path(value="elementId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="devicegroups/{groupToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForDeviceGroup(@Path(value="groupToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @POST(value="devicestates/search")
    public Call<SearchResults<DeviceState>> listDeviceStates(@Body DeviceStateSearchCriteria var1, @Query(value="includeArea") Boolean var2, @Query(value="includeAsset") Boolean var3, @Query(value="includeCustomer") Boolean var4, @Query(value="includeDevice") Boolean var5, @Query(value="includeDeviceAssignment") Boolean var6, @Query(value="includeDeviceType") Boolean var7, @Query(value="includeEventDetails") Boolean var8, @HeaderMap Map<String, String> var9);

    @GET(value="statuses")
    public Call<SearchResults<DeviceStatus>> listDeviceStatuses(@Query(value="code") String var1, @Query(value="deviceTypeToken") String var2, @Query(value="page") Integer var3, @Query(value="pageSize") Integer var4, @HeaderMap Map<String, String> var5);

    @GET(value="statuses/{token}")
    public Call<DeviceStatus> getDeviceStatusByToken(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="statuses")
    public Call<DeviceStatus> createDeviceStatus(@Body DeviceStatusCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="statuses/{token}")
    public Call<DeviceStatus> updateDeviceStatus(@Path(value="token") String var1, @Body DeviceStatusCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="statuses/{token}")
    public Call<DeviceStatus> deleteDeviceStatus(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devicetypes")
    public Call<SearchResults<DeviceType>> listDeviceTypes(@Query(value="includeAsset") Boolean var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="devicetypes/{token}")
    public Call<DeviceType> getDeviceTypeByToken(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="devicetypes")
    public Call<DeviceType> createDeviceType(@Body DeviceTypeCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="devicetypes/{token}")
    public Call<DeviceType> updateDeviceType(@Path(value="token") String var1, @Body DeviceTypeCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="devicetypes/{token}")
    public Call<DeviceType> deleteDeviceType(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devicetypes/{token}/label/{generatorId}")
    public Call<ResponseBody> getLabelForDeviceType(@Path(value="token") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="devicetypes/{token}/proto")
    public Call<ResponseBody> getDeviceTypeGPBSpecification(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devicetypes/{token}/spec.proto")
    public Call<ResponseBody> downlaodDeviceTypeGPBSpecification(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devices")
    public Call<SearchResults<Device>> listDevices(@Query(value="deviceType") String var1, @Query(value="excludeAssigned") Boolean var2, @Query(value="includeAssignment") Boolean var3, @Query(value="includeDeviceType") Boolean var4, @Query(value="startDate") String var5, @Query(value="endDate") String var6, @Query(value="page") Integer var7, @Query(value="pageSize") Integer var8, @HeaderMap Map<String, String> var9);

    @GET(value="devices/{deviceToken}")
    public Call<MarshaledDevice> getDeviceByToken(@Path(value="deviceToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="devices")
    public Call<MarshaledDevice> createDevice(@Body DeviceCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="devices/{deviceToken}")
    public Call<MarshaledDevice> updateDevice(@Path(value="deviceToken") String var1, @Body DeviceCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="devices/{deviceToken}")
    public Call<MarshaledDevice> deleteDevice(@Path(value="deviceToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="devices/{deviceToken}/assignments")
    public Call<SearchResults<MarshaledDeviceAssignment>> listDeviceAssignmentsForDevice(@Path(value="deviceToken") String var1, @Query(value="includeArea") Boolean var2, @Query(value="includeAsset") Boolean var3, @Query(value="includeCustomer") Boolean var4, @Query(value="includeDevice") Boolean var5, @Query(value="page") Integer var6, @Query(value="pageSize") Integer var7, @HeaderMap Map<String, String> var8);

    @GET(value="devices/{deviceToken}/assignments/active")
    public Call<List<MarshaledDeviceAssignment>> getActiveAssignmentsForDevice(@Path(value="deviceToken") String var1, @Query(value="includeArea") Boolean var2, @Query(value="includeAsset") Boolean var3, @Query(value="includeCustomer") Boolean var4, @Query(value="includeDevice") Boolean var5, @Query(value="page") Integer var6, @Query(value="pageSize") Integer var7, @HeaderMap Map<String, String> var8);

    @POST(value="devices/{deviceToken}/batch")
    public Call<DeviceEventBatchResponse> addMultipleEventsForDevice(@Path(value="deviceToken") String var1, @Body DeviceEventBatch var2, @HeaderMap Map<String, String> var3);

    @GET(value="devices/{deviceToken}/label/{generatorId}")
    public Call<ResponseBody> getLabelForDevice(@Path(value="deviceToken") String var1, @Path(value="generatorId") String var2, @HeaderMap Map<String, String> var3);

    @POST(value="devices/{deviceToken}/mappings")
    public Call<MarshaledDevice> createDeviceMappings(@Path(value="deviceToken") String var1, @Body DeviceElementMapping var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="devices/{deviceToken}/mappings")
    public Call<MarshaledDevice> deleteDeviceMappings(@Path(value="deviceToken") String var1, @Path(value="path") String var2, @HeaderMap Map<String, String> var3);

    @GET(value="devices/group/{groupToken}")
    public Call<SearchResults<Device>> listDevicesByDeviceGroup(@Path(value="groupToken") String var1, @Query(value="deviceType") String var2, @Query(value="excludeAssigned") Boolean var3, @Query(value="includeAssignment") Boolean var4, @Query(value="includeDeleted") Boolean var5, @Query(value="includeDeviceType") Boolean var6, @Query(value="startDate") String var7, @Query(value="endDate") String var8, @Query(value="page") Integer var9, @Query(value="pageSize") Integer var10, @HeaderMap Map<String, String> var11);

    @GET(value="devices/grouprole/{role}")
    public Call<SearchResults<Device>> listDevicesByDeviceGroupWithRole(@Path(value="role") String var1, @Query(value="deviceType") String var2, @Query(value="excludeAssigned") Boolean var3, @Query(value="includeAssignment") Boolean var4, @Query(value="includeDeleted") Boolean var5, @Query(value="includeDeviceType") Boolean var6, @Query(value="startDate") String var7, @Query(value="endDate") String var8, @Query(value="page") Integer var9, @Query(value="pageSize") Integer var10, @HeaderMap Map<String, String> var11);

    @GET(value="jobs")
    public Call<SearchResults<ScheduledJob>> listScheduledJobs(@Query(value="includeContext") Boolean var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="jobs/{token}")
    public Call<ScheduledJob> getScheduledJobByToken(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="jobs")
    public Call<ScheduledJob> createScheduledJob(@Body ScheduledJobCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="jobs/{token}")
    public Call<ScheduledJob> updateScheduledJob(@Path(value="token") String var1, @Body ScheduledJobCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="jobs/{token}")
    public Call<ScheduledJob> deleteScheduledJob(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="schedules")
    public Call<SearchResults<Schedule>> listSchedules(@Query(value="page") Integer var1, @Query(value="pageSize") Integer var2, @HeaderMap Map<String, String> var3);

    @GET(value="schedules/{token}")
    public Call<Schedule> getScheduleByToken(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="schedules")
    public Call<Schedule> createSchedule(@Body ScheduleCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="schedules/{token}")
    public Call<Schedule> updateSchedule(@Path(value="token") String var1, @Body ScheduleCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="schedules/{token}")
    public Call<Schedule> deleteSchedule(@Path(value="token") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="system/version")
    public Call<Version> getVersion();

    @GET(value="tenants")
    public Call<SearchResults<Tenant>> listTenants(@Query(value="authUserId") String var1, @Query(value="textSearch") String var2, @Query(value="includeRuntimeInfo") Boolean var3, @Query(value="page") Integer var4, @Query(value="pageSize") Integer var5, @HeaderMap Map<String, String> var6);

    @GET(value="tenants/{tenantToken}")
    public Call<Tenant> getTenantByToken(@Path(value="tenantToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="tenants")
    public Call<Tenant> createTenant(@Body TenantCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="tenants/{tenantToken}")
    public Call<Tenant> updateTenant(@Path(value="tenantToken") String var1, @Body TenantCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="tenants/{tenantToken}")
    public Call<Tenant> deleteTenant(@Path(value="tenantToken") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="users")
    public Call<SearchResults<User>> listUsers(@HeaderMap Map<String, String> var1);

    @GET(value="users/{username}")
    public Call<User> getUserByUsername(@Path(value="username") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="users")
    public Call<User> createUser(@Body UserCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="users/{username}")
    public Call<User> updateUser(@Path(value="username") String var1, @Body UserCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="users/{username}")
    public Call<User> deleteUser(@Path(value="username") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="users/{username}/authorities")
    public Call<SearchResults<GrantedAuthority>> listUserAuthorities(@Path(value="username") String var1, @HeaderMap Map<String, String> var2);

    @GET(value="zones")
    public Call<SearchResults<Zone>> listZones(@Query(value="areaToken") String var1, @Query(value="page") Integer var2, @Query(value="pageSize") Integer var3, @HeaderMap Map<String, String> var4);

    @GET(value="zones/{zoneToken}")
    public Call<Zone> getZoneByToken(@Path(value="zoneToken") String var1, @HeaderMap Map<String, String> var2);

    @POST(value="zones")
    public Call<Zone> createZone(@Body ZoneCreateRequest var1, @HeaderMap Map<String, String> var2);

    @PUT(value="zones/{zoneToken}")
    public Call<Zone> updateZone(@Path(value="zoneToken") String var1, @Body ZoneCreateRequest var2, @HeaderMap Map<String, String> var3);

    @DELETE(value="zones/{zoneToken}")
    public Call<Zone> deleteZone(@Path(value="zoneToken") String var1, @HeaderMap Map<String, String> var2);
}

