/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.client;

import com.sitewhere.rest.client.AuthenticationRetrofit;
import com.sitewhere.rest.client.Base64;
import com.sitewhere.rest.client.SiteWhereRestRetrofit;
import com.sitewhere.rest.client.TenantAuthentication;
import com.sitewhere.rest.model.area.Area;
import com.sitewhere.rest.model.area.AreaType;
import com.sitewhere.rest.model.area.Zone;
import com.sitewhere.rest.model.area.request.AreaCreateRequest;
import com.sitewhere.rest.model.area.request.AreaTypeCreateRequest;
import com.sitewhere.rest.model.area.request.ZoneCreateRequest;
import com.sitewhere.rest.model.asset.Asset;
import com.sitewhere.rest.model.asset.AssetType;
import com.sitewhere.rest.model.asset.marshaling.MarshaledAsset;
import com.sitewhere.rest.model.asset.request.AssetCreateRequest;
import com.sitewhere.rest.model.asset.request.AssetTypeCreateRequest;
import com.sitewhere.rest.model.batch.BatchElement;
import com.sitewhere.rest.model.batch.BatchOperation;
import com.sitewhere.rest.model.batch.request.BatchCommandInvocationRequest;
import com.sitewhere.rest.model.batch.request.InvocationByDeviceCriteriaRequest;
import com.sitewhere.rest.model.customer.Customer;
import com.sitewhere.rest.model.customer.CustomerType;
import com.sitewhere.rest.model.customer.request.CustomerCreateRequest;
import com.sitewhere.rest.model.customer.request.CustomerTypeCreateRequest;
import com.sitewhere.rest.model.datatype.JsonDateSerializer;
import com.sitewhere.rest.model.device.Device;
import com.sitewhere.rest.model.device.DeviceElementMapping;
import com.sitewhere.rest.model.device.DeviceStatus;
import com.sitewhere.rest.model.device.DeviceType;
import com.sitewhere.rest.model.device.asset.DeviceAlertWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceCommandResponseWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceEventWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceLocationWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceMeasurementWithAsset;
import com.sitewhere.rest.model.device.asset.DeviceStateChangeWithAsset;
import com.sitewhere.rest.model.device.charting.ChartSeries;
import com.sitewhere.rest.model.device.command.DeviceCommand;
import com.sitewhere.rest.model.device.command.DeviceCommandNamespace;
import com.sitewhere.rest.model.device.event.DeviceCommandInvocation;
import com.sitewhere.rest.model.device.event.DeviceCommandResponse;
import com.sitewhere.rest.model.device.event.DeviceEventBatch;
import com.sitewhere.rest.model.device.event.DeviceEventBatchResponse;
import com.sitewhere.rest.model.device.event.request.DeviceAlertCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceCommandInvocationCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceCommandResponseCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceLocationCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceMeasurementCreateRequest;
import com.sitewhere.rest.model.device.event.request.DeviceStateChangeCreateRequest;
import com.sitewhere.rest.model.device.event.view.DeviceCommandInvocationSummary;
import com.sitewhere.rest.model.device.group.DeviceGroup;
import com.sitewhere.rest.model.device.group.DeviceGroupElement;
import com.sitewhere.rest.model.device.marshaling.MarshaledArea;
import com.sitewhere.rest.model.device.marshaling.MarshaledAreaType;
import com.sitewhere.rest.model.device.marshaling.MarshaledCustomer;
import com.sitewhere.rest.model.device.marshaling.MarshaledDevice;
import com.sitewhere.rest.model.device.marshaling.MarshaledDeviceAssignment;
import com.sitewhere.rest.model.device.request.DeviceAssignmentBulkRequest;
import com.sitewhere.rest.model.device.request.DeviceAssignmentCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceCommandCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceGroupCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceGroupElementCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceStatusCreateRequest;
import com.sitewhere.rest.model.device.request.DeviceTypeCreateRequest;
import com.sitewhere.rest.model.device.state.DeviceState;
import com.sitewhere.rest.model.scheduling.Schedule;
import com.sitewhere.rest.model.scheduling.ScheduledJob;
import com.sitewhere.rest.model.scheduling.request.ScheduleCreateRequest;
import com.sitewhere.rest.model.scheduling.request.ScheduledJobCreateRequest;
import com.sitewhere.rest.model.search.DateRangeSearchCriteria;
import com.sitewhere.rest.model.search.SearchCriteria;
import com.sitewhere.rest.model.search.SearchResults;
import com.sitewhere.rest.model.search.TreeNode;
import com.sitewhere.rest.model.search.area.AreaResponseFormat;
import com.sitewhere.rest.model.search.area.AreaSearchCriteria;
import com.sitewhere.rest.model.search.area.AreaTypeSearchCriteria;
import com.sitewhere.rest.model.search.asset.AssetSearchCriteria;
import com.sitewhere.rest.model.search.asset.AssetTypeSearchCriteria;
import com.sitewhere.rest.model.search.batch.BatchOperationSearchCriteria;
import com.sitewhere.rest.model.search.customer.CustomerResponseFormat;
import com.sitewhere.rest.model.search.customer.CustomerSearchCriteria;
import com.sitewhere.rest.model.search.customer.CustomerTypeResponseFormat;
import com.sitewhere.rest.model.search.customer.CustomerTypeSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceAssignmentResponseFormat;
import com.sitewhere.rest.model.search.device.DeviceAssignmentSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceByGroupResponseFormat;
import com.sitewhere.rest.model.search.device.DeviceCommandSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceGroupElementResponseFormat;
import com.sitewhere.rest.model.search.device.DeviceGroupElementSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceGroupSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceResponseFormat;
import com.sitewhere.rest.model.search.device.DeviceSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceStateResponseFormat;
import com.sitewhere.rest.model.search.device.DeviceStateSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceStatusSearchCriteria;
import com.sitewhere.rest.model.search.device.DeviceTypeResponseFormat;
import com.sitewhere.rest.model.search.device.DeviceTypeSearchCriteria;
import com.sitewhere.rest.model.search.device.ZoneSearchCriteria;
import com.sitewhere.rest.model.search.scheduling.ScheduleResponseFormat;
import com.sitewhere.rest.model.search.scheduling.ScheduleSearchCriteria;
import com.sitewhere.rest.model.search.scheduling.ScheduledJobResponseFormat;
import com.sitewhere.rest.model.search.scheduling.ScheduledJobSearchCriteria;
import com.sitewhere.rest.model.search.tenant.TenantSearchCriteria;
import com.sitewhere.rest.model.system.Version;
import com.sitewhere.rest.model.tenant.Tenant;
import com.sitewhere.rest.model.tenant.request.TenantCreateRequest;
import com.sitewhere.rest.model.user.GrantedAuthority;
import com.sitewhere.rest.model.user.GrantedAuthorityHierarchyNode;
import com.sitewhere.rest.model.user.User;
import com.sitewhere.rest.model.user.request.GrantedAuthorityCreateRequest;
import com.sitewhere.rest.model.user.request.UserCreateRequest;
import com.sitewhere.spi.ISiteWhereClient;
import com.sitewhere.spi.ITenantAuthentication;
import com.sitewhere.spi.SiteWhereException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class SiteWhereClient
implements ISiteWhereClient {
    private static SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 80;
    public static final String AUTH_RELATIVE_URL = "/sitewhere/authapi/";
    public static final String REST_RELATIVE_URL = "/sitewhere/api/";
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "password";
    public static final int DEFAULT_CONNECT_TIMEOUT = 3000;
    private static final String CONTENT_DISPOSITION_HEADER = "content-disposition";
    private String protocol = "http";
    private String hostname = "localhost";
    private int port = 80;
    private String username = "admin";
    private String password = "password";
    private int connectTimeout = 3000;
    private AuthenticationRetrofit authRetrofit;
    private SiteWhereRestRetrofit restRetrofit;
    private String jwt;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public SearchResults<AreaType> listAreaTypes(ITenantAuthentication tenant, AreaTypeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<AreaType>> call = this.getRestRetrofit().listAreaTypes(searchCriteria.getIncludeContainedAreaTypes(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledAreaType getAreaTypeByToken(ITenantAuthentication tenant, String areaTypeToken) throws SiteWhereException {
        Call<MarshaledAreaType> call = this.getRestRetrofit().getAreaTypeByToken(areaTypeToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AreaType createAreaType(ITenantAuthentication tenant, AreaTypeCreateRequest request) throws SiteWhereException {
        Call<AreaType> call = this.getRestRetrofit().createAreaType(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AreaType updateAreaType(ITenantAuthentication tenant, String areaTypeToken, AreaTypeCreateRequest request) throws SiteWhereException {
        Call<AreaType> call = this.getRestRetrofit().updateAreaType(areaTypeToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AreaType deleteAreaType(ITenantAuthentication tenant, String areaTypeToken) throws SiteWhereException {
        Call<AreaType> call = this.getRestRetrofit().deleteAreaType(areaTypeToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForAreaType(ITenantAuthentication tenant, String areaTypeToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForAreaType(areaTypeToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<Area> listAreas(ITenantAuthentication tenant, AreaSearchCriteria searchCriteria, AreaResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<Area>> call = this.getRestRetrofit().listAreas(searchCriteria.getAreaTypeToken(), responseFormat.getIncludeAreaType(), responseFormat.getIncludeAssignments(), responseFormat.getIncludeZones(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), searchCriteria.getParentAreaToken(), searchCriteria.getRootOnly(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledArea getAreaByToken(ITenantAuthentication tenant, String areaToken) throws SiteWhereException {
        Call<MarshaledArea> call = this.getRestRetrofit().getAreaByToken(areaToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Area createArea(ITenantAuthentication tenant, AreaCreateRequest request) throws SiteWhereException {
        Call<Area> call = this.getRestRetrofit().createArea(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Area updateArea(ITenantAuthentication tenant, String areaToken, AreaCreateRequest request) throws SiteWhereException {
        Call<Area> call = this.getRestRetrofit().updateArea(areaToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Area deleteArea(ITenantAuthentication tenant, String areaToken) throws SiteWhereException {
        Call<Area> call = this.getRestRetrofit().deleteArea(areaToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceAlertWithAsset> listAlertsForArea(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceAlertWithAsset>> call = this.getRestRetrofit().listAlertsForArea(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<MarshaledDeviceAssignment> listDeviceAssignmentsForArea(ITenantAuthentication tenant, String areaToken, DeviceAssignmentSearchCriteria searchCriteria, DeviceAssignmentResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<MarshaledDeviceAssignment>> call = this.getRestRetrofit().listDeviceAssignmentsForArea(areaToken, SiteWhereClient.assembleList(searchCriteria.getAssignmentStatuses()), responseFormat.getIncludeDevice(), responseFormat.getIncludeCustomer(), responseFormat.getIncludeArea(), responseFormat.getIncludeAsset(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandInvocation> listCommandInvocationsForArea(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandInvocation>> call = this.getRestRetrofit().listCommandInvocationsForArea(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForArea(ITenantAuthentication tenant, String areaToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForArea(areaToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<DeviceLocationWithAsset> listLocationsForArea(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceLocationWithAsset>> call = this.getRestRetrofit().listLocationsForArea(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceMeasurementWithAsset> listMeasurementsForArea(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceMeasurementWithAsset>> call = this.getRestRetrofit().listMeasurementsForArea(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandResponseWithAsset> listCommandResponsesForArea(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandResponseWithAsset>> call = this.getRestRetrofit().listCommandResponsesForArea(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceStateChangeWithAsset> listStateChangesForArea(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceStateChangeWithAsset>> call = this.getRestRetrofit().listStateChangesForArea(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public List<TreeNode> areaTree(ITenantAuthentication tenant) throws SiteWhereException {
        Call<List<TreeNode>> call = this.getRestRetrofit().areaTree(this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<AssetType> listAssetTypes(ITenantAuthentication tenant, AssetTypeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<AssetType>> call = this.getRestRetrofit().listAssetTypes(searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AssetType getAssetTypeByToken(ITenantAuthentication tenant, String assetTypeToken) throws SiteWhereException {
        Call<AssetType> call = this.getRestRetrofit().getAssetTypeByToken(assetTypeToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AssetType createAssetType(ITenantAuthentication tenant, AssetTypeCreateRequest request) throws SiteWhereException {
        Call<AssetType> call = this.getRestRetrofit().createAssetType(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AssetType updateAssetType(ITenantAuthentication tenant, String assetTypeToken, AssetTypeCreateRequest request) throws SiteWhereException {
        Call<AssetType> call = this.getRestRetrofit().updateAssetType(assetTypeToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public AssetType deleteAssetType(ITenantAuthentication tenant, String assetTypeToken) throws SiteWhereException {
        Call<AssetType> call = this.getRestRetrofit().deleteAssetType(assetTypeToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForAssetType(ITenantAuthentication tenant, String assetTypeToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForAssetType(assetTypeToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<Asset> listAssets(ITenantAuthentication tenant, AssetSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<Asset>> call = this.getRestRetrofit().listAssets(searchCriteria.getAssetTypeToken(), searchCriteria.getIncludeAssetType(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledAsset getAssetByToken(ITenantAuthentication tenant, String assetToken) throws SiteWhereException {
        Call<MarshaledAsset> call = this.getRestRetrofit().getAssetByToken(assetToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Asset createAsset(ITenantAuthentication tenant, AssetCreateRequest request) throws SiteWhereException {
        Call<Asset> call = this.getRestRetrofit().createAsset(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Asset updateAsset(ITenantAuthentication tenant, String assetToken, AssetCreateRequest request) throws SiteWhereException {
        Call<Asset> call = this.getRestRetrofit().updateAsset(assetToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Asset deleteAsset(ITenantAuthentication tenant, String assetToken) throws SiteWhereException {
        Call<Asset> call = this.getRestRetrofit().deleteAsset(assetToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForAsset(ITenantAuthentication tenant, String assetToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForAsset(assetToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<MarshaledDeviceAssignment> listDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentSearchCriteria searchCriteria, DeviceAssignmentResponseFormat format) throws SiteWhereException {
        Call<SearchResults<MarshaledDeviceAssignment>> call = this.getRestRetrofit().listDeviceAssignments(SiteWhereClient.assembleTokenList(searchCriteria.getAreaTokens()), format.getIncludeArea(), SiteWhereClient.assembleTokenList(searchCriteria.getAssetTokens()), format.getIncludeAsset(), SiteWhereClient.assembleTokenList(searchCriteria.getCustomerTokens()), format.getIncludeCustomer(), SiteWhereClient.assembleTokenList(searchCriteria.getDeviceTokens()), format.getIncludeDevice(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDeviceAssignment getDeviceAssignmentByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<MarshaledDeviceAssignment> call = this.getRestRetrofit().getDeviceAssignmentByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDeviceAssignment createDeviceAssignment(ITenantAuthentication tenant, DeviceAssignmentCreateRequest request) throws SiteWhereException {
        Call<MarshaledDeviceAssignment> call = this.getRestRetrofit().createDeviceAssignment(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDeviceAssignment updateDeviceAssignment(ITenantAuthentication tenant, String token, DeviceAssignmentCreateRequest request) throws SiteWhereException {
        Call<MarshaledDeviceAssignment> call = this.getRestRetrofit().updateDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDeviceAssignment deleteDeviceAssignment(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<MarshaledDeviceAssignment> call = this.getRestRetrofit().deleteDeviceAssignment(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceAlertWithAsset> listAlertsForDeviceAssignment(ITenantAuthentication tenant, String areaToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceAlertWithAsset>> call = this.getRestRetrofit().listAlertsForDeviceAssignment(areaToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceAlertWithAsset createAlertForDeviceAssignment(ITenantAuthentication tenant, String token, DeviceAlertCreateRequest request) throws SiteWhereException {
        Call<DeviceAlertWithAsset> call = this.getRestRetrofit().createAlertForDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDeviceAssignment releaseDeviceAssignment(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<MarshaledDeviceAssignment> call = this.getRestRetrofit().releaseDeviceAssignment(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandInvocation> listCommandInvocationsForDeviceAssignment(ITenantAuthentication tenant, String token, Boolean includeCommand, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandInvocation>> call = this.getRestRetrofit().listCommandInvocationsForDeviceAssignment(token, includeCommand, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommandInvocation createCommandInvocationForDeviceAssignment(ITenantAuthentication tenant, String token, DeviceCommandInvocationCreateRequest request) throws SiteWhereException {
        Call<DeviceCommandInvocation> call = this.getRestRetrofit().createCommandInvocationForDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public ScheduledJob scheduleCommandInvocation(ITenantAuthentication tenant, String token, String scheduleToken, DeviceCommandInvocationCreateRequest request) throws SiteWhereException {
        Call<ScheduledJob> call = this.getRestRetrofit().scheduleCommandInvocation(token, scheduleToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForDeviceAssignment(ITenantAuthentication tenant, String token, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForDeviceAssignment(token, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<DeviceLocationWithAsset> listLocationsForDeviceAssignment(ITenantAuthentication tenant, String token, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceLocationWithAsset>> call = this.getRestRetrofit().listLocationsForDeviceAssignment(token, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceLocationWithAsset createLocationForDeviceAssignment(ITenantAuthentication tenant, String token, DeviceLocationCreateRequest request) throws SiteWhereException {
        Call<DeviceLocationWithAsset> call = this.getRestRetrofit().createLocationForDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceMeasurementWithAsset> listMeasurementsForDeviceAssignment(ITenantAuthentication tenant, String token, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceMeasurementWithAsset>> call = this.getRestRetrofit().listMeasurementsForDeviceAssignment(token, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceMeasurementWithAsset createMeasurementForDeviceAssignment(ITenantAuthentication tenant, String token, DeviceMeasurementCreateRequest request) throws SiteWhereException {
        Call<DeviceMeasurementWithAsset> call = this.getRestRetrofit().createMeasurementForDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public List<ChartSeries<Double>> listMeasurementsForDeviceAssignmentAsChartSeries(ITenantAuthentication tenant, String token, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<List<ChartSeries<Double>>> call = this.getRestRetrofit().listMeasurementsForDeviceAssignmentAsChartSeries(token, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDeviceAssignment markMissingDeviceAssignment(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<MarshaledDeviceAssignment> call = this.getRestRetrofit().markMissingDeviceAssignment(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandResponseWithAsset> listCommandResponsesForDeviceAssignment(ITenantAuthentication tenant, String token, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandResponseWithAsset>> call = this.getRestRetrofit().listCommandResponsesForDeviceAssignment(token, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommandResponseWithAsset createCommandResponseForDeviceAssignment(ITenantAuthentication tenant, String token, DeviceCommandResponseCreateRequest request) throws SiteWhereException {
        Call<DeviceCommandResponseWithAsset> call = this.getRestRetrofit().createCommandResponseForDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceStateChangeWithAsset> listStateChangesForDeviceAssignment(ITenantAuthentication tenant, String token, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceStateChangeWithAsset>> call = this.getRestRetrofit().listStateChangesForDeviceAssignment(token, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceStateChangeWithAsset createStateChangeForDeviceAssignment(ITenantAuthentication tenant, String token, DeviceStateChangeCreateRequest request) throws SiteWhereException {
        Call<DeviceStateChangeWithAsset> call = this.getRestRetrofit().createStateChangeForDeviceAssignment(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceAlertWithAsset> bulkListAlertsForDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<SearchResults<DeviceAlertWithAsset>> call = this.getRestRetrofit().bulkListAlertsForDeviceAssignments(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandInvocation> bulkListCommandInvocationsForDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<SearchResults<DeviceCommandInvocation>> call = this.getRestRetrofit().bulkListCommandInvocationsForDeviceAssignments(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceLocationWithAsset> bulkListLocationsForDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<SearchResults<DeviceLocationWithAsset>> call = this.getRestRetrofit().bulkListLocationsForDeviceAssignments(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceMeasurementWithAsset> bulkListMeasurementsForDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<SearchResults<DeviceMeasurementWithAsset>> call = this.getRestRetrofit().bulkListMeasurementsForDeviceAssignments(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Map<String, List<ChartSeries<Double>>> bulkListMeasurementsForDeviceAssignmentsAsChartSeries(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<Map<String, List<ChartSeries<Double>>>> call = this.getRestRetrofit().bulkListMeasurementsForDeviceAssignmentsAsChartSeries(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandResponseWithAsset> bulkListCommandResponsesForDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<SearchResults<DeviceCommandResponseWithAsset>> call = this.getRestRetrofit().bulkListCommandResponsesForDeviceAssignments(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceStateChangeWithAsset> bulkListStateChangesForDeviceAssignments(ITenantAuthentication tenant, DeviceAssignmentBulkRequest request) throws SiteWhereException {
        Call<SearchResults<DeviceStateChangeWithAsset>> call = this.getRestRetrofit().bulkListStateChangesForDeviceAssignments(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<GrantedAuthority> listAuthorities(ITenantAuthentication tenant) throws SiteWhereException {
        Call<SearchResults<GrantedAuthority>> call = this.getRestRetrofit().listAuthorities(this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public GrantedAuthority getAuthorityByName(ITenantAuthentication tenant, String name) throws SiteWhereException {
        Call<GrantedAuthority> call = this.getRestRetrofit().getAuthorityByName(name, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public GrantedAuthority createAuthority(ITenantAuthentication tenant, GrantedAuthorityCreateRequest request) throws SiteWhereException {
        Call<GrantedAuthority> call = this.getRestRetrofit().createAuthority(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public List<GrantedAuthorityHierarchyNode> getAuthoritiesHierarchy(ITenantAuthentication tenant) throws SiteWhereException {
        Call<List<GrantedAuthorityHierarchyNode>> call = this.getRestRetrofit().getAuthoritiesHierarchy(this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<BatchOperation> listBatchOperations(ITenantAuthentication tenant, BatchOperationSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<BatchOperation>> call = this.getRestRetrofit().listBatchOperations(searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public BatchOperation getBatchOperationByToken(ITenantAuthentication tenant, String batchToken) throws SiteWhereException {
        Call<BatchOperation> call = this.getRestRetrofit().getBatchOperationByToken(batchToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<BatchElement> listBatchOperationElements(ITenantAuthentication tenant, String operationToken) throws SiteWhereException {
        Call<SearchResults<BatchElement>> call = this.getRestRetrofit().listBatchOperationElements(operationToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public BatchOperation createBatchCommandInvocation(ITenantAuthentication tenant, BatchCommandInvocationRequest request) throws SiteWhereException {
        Call<BatchOperation> call = this.getRestRetrofit().createBatchCommandInvocation(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Object createBatchCommandOperationForCriteria(ITenantAuthentication tenant, InvocationByDeviceCriteriaRequest request) throws SiteWhereException {
        Call<Object> call = this.getRestRetrofit().createBatchCommandOperationForCriteria(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommandInvocation getDeviceCommandInvocation(ITenantAuthentication tenant, String id) throws SiteWhereException {
        Call<DeviceCommandInvocation> call = this.getRestRetrofit().getDeviceCommandInvocation(id, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommandInvocationSummary getDeviceCommandInvocationSummary(ITenantAuthentication tenant, String id) throws SiteWhereException {
        Call<DeviceCommandInvocationSummary> call = this.getRestRetrofit().getDeviceCommandInvocationSummary(id, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandResponse> listCommandResponsesForCommandInvocation(ITenantAuthentication tenant, String id) throws SiteWhereException {
        Call<SearchResults<DeviceCommandResponse>> call = this.getRestRetrofit().listCommandResponsesForCommandInvocation(id, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<CustomerType> listCustomerTypes(ITenantAuthentication tenant, CustomerTypeSearchCriteria searchCriteria, CustomerTypeResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<CustomerType>> call = this.getRestRetrofit().listCustomerTypes(responseFormat.getIncludeContainedCustomerTypes(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public CustomerType getCustomerTypeByToken(ITenantAuthentication tenant, String customerTypeToken) throws SiteWhereException {
        Call<CustomerType> call = this.getRestRetrofit().getCustomerTypeByToken(customerTypeToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public CustomerType createCustomerType(ITenantAuthentication tenant, CustomerTypeCreateRequest request) throws SiteWhereException {
        Call<CustomerType> call = this.getRestRetrofit().createCustomerType(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public CustomerType updateCustomerType(ITenantAuthentication tenant, String customerTypeToken, CustomerTypeCreateRequest request) throws SiteWhereException {
        Call<CustomerType> call = this.getRestRetrofit().updateCustomerType(customerTypeToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public CustomerType deleteCustomerType(ITenantAuthentication tenant, String customerTypeToken) throws SiteWhereException {
        Call<CustomerType> call = this.getRestRetrofit().deleteCustomerType(customerTypeToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForCustomerType(ITenantAuthentication tenant, String customerTypeToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForCustomerType(customerTypeToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<Customer> listCustomers(ITenantAuthentication tenant, CustomerSearchCriteria searchCriteria, CustomerResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<Customer>> call = this.getRestRetrofit().listCustomers(searchCriteria.getCustomerTypeToken(), searchCriteria.getParentCustomerToken(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), responseFormat.getIncludeCustomerType(), searchCriteria.getRootOnly(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledCustomer getCustomerByToken(ITenantAuthentication tenant, String customerToken) throws SiteWhereException {
        Call<MarshaledCustomer> call = this.getRestRetrofit().getCustomerByToken(customerToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Customer createCustomer(ITenantAuthentication tenant, CustomerCreateRequest request) throws SiteWhereException {
        Call<Customer> call = this.getRestRetrofit().createCustomer(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Customer updateCustomer(ITenantAuthentication tenant, String customerToken, CustomerCreateRequest request) throws SiteWhereException {
        Call<Customer> call = this.getRestRetrofit().updateCustomer(customerToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Customer deleteCustomer(ITenantAuthentication tenant, String customerToken) throws SiteWhereException {
        Call<Customer> call = this.getRestRetrofit().deleteCustomer(customerToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceAlertWithAsset> listAlertsForCustomer(ITenantAuthentication tenant, String customerToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceAlertWithAsset>> call = this.getRestRetrofit().listAlertsForCustomer(customerToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<MarshaledDeviceAssignment> listDeviceAssignmentsForCustomer(ITenantAuthentication tenant, String customerToken, DeviceAssignmentSearchCriteria searchCriteria, DeviceAssignmentResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<MarshaledDeviceAssignment>> call = this.getRestRetrofit().listDeviceAssignmentsForCustomer(customerToken, SiteWhereClient.assembleList(searchCriteria.getAssignmentStatuses()), responseFormat.getIncludeDevice(), responseFormat.getIncludeCustomer(), responseFormat.getIncludeArea(), responseFormat.getIncludeAsset(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandInvocation> listCommandInvocationsForCustomer(ITenantAuthentication tenant, String customerToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandInvocation>> call = this.getRestRetrofit().listCommandInvocationsForCustomer(customerToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForCustomer(ITenantAuthentication tenant, String customerToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForCustomer(customerToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<DeviceLocationWithAsset> listLocationsForCustomer(ITenantAuthentication tenant, String customerToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceLocationWithAsset>> call = this.getRestRetrofit().listLocationsForCustomer(customerToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceMeasurementWithAsset> listMeasurementsForCustomer(ITenantAuthentication tenant, String customerToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceMeasurementWithAsset>> call = this.getRestRetrofit().listMeasurementsForCustomer(customerToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandResponseWithAsset> listCommandResponsesForCustomer(ITenantAuthentication tenant, String customerToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandResponseWithAsset>> call = this.getRestRetrofit().listCommandResponsesForCustomer(customerToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceStateChangeWithAsset> listStateChangesForCustomer(ITenantAuthentication tenant, String customerToken, DateRangeSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceStateChangeWithAsset>> call = this.getRestRetrofit().listStateChangesForCustomer(customerToken, this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public List<TreeNode> customerTree(ITenantAuthentication tenant) throws SiteWhereException {
        Call<List<TreeNode>> call = this.getRestRetrofit().areaTree(this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommand> listDeviceCommands(ITenantAuthentication tenant, DeviceCommandSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommand>> call = this.getRestRetrofit().listDeviceCommands(searchCriteria.getDeviceTypeToken(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommand getDeviceCommandByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceCommand> call = this.getRestRetrofit().getDeviceCommandByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommand createDeviceCommand(ITenantAuthentication tenant, DeviceCommandCreateRequest request) throws SiteWhereException {
        Call<DeviceCommand> call = this.getRestRetrofit().createDeviceCommand(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommand updateDeviceCommand(ITenantAuthentication tenant, String token, DeviceCommandCreateRequest request) throws SiteWhereException {
        Call<DeviceCommand> call = this.getRestRetrofit().updateDeviceCommand(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceCommand deleteDeviceCommand(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceCommand> call = this.getRestRetrofit().deleteDeviceCommand(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceCommandNamespace> listDeviceCommandsByNamesapce(ITenantAuthentication tenant, DeviceCommandSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceCommandNamespace>> call = this.getRestRetrofit().listDeviceCommandsByNamesapce(searchCriteria.getDeviceTypeToken(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceEventWithAsset getDeviceEventByAlternateId(ITenantAuthentication tenant, String alternateId) throws SiteWhereException {
        Call<DeviceEventWithAsset> call = this.getRestRetrofit().getDeviceEventByAlternateId(alternateId, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceEventWithAsset getDeviceEventById(ITenantAuthentication tenant, String eventId) throws SiteWhereException {
        Call<DeviceEventWithAsset> call = this.getRestRetrofit().getDeviceEventById(eventId, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceGroup> listDeviceGroups(ITenantAuthentication tenant, DeviceGroupSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceGroup>> call = this.getRestRetrofit().listDeviceGroups(searchCriteria.getRole(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceGroup getDeviceGroupByToken(ITenantAuthentication tenant, String groupToken) throws SiteWhereException {
        Call<DeviceGroup> call = this.getRestRetrofit().getDeviceGroupByToken(groupToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceGroup createDeviceGroup(ITenantAuthentication tenant, DeviceGroupCreateRequest request) throws SiteWhereException {
        Call<DeviceGroup> call = this.getRestRetrofit().createDeviceGroup(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceGroup updateDeviceGroup(ITenantAuthentication tenant, String groupToken, DeviceGroupCreateRequest request) throws SiteWhereException {
        Call<DeviceGroup> call = this.getRestRetrofit().updateDeviceGroup(groupToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceGroup deleteDeviceGroup(ITenantAuthentication tenant, String groupToken) throws SiteWhereException {
        Call<DeviceGroup> call = this.getRestRetrofit().deleteDeviceGroup(groupToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceGroupElement> listDeviceGroupElements(ITenantAuthentication tenant, DeviceGroupElementSearchCriteria searchCriteria, DeviceGroupElementResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<DeviceGroupElement>> call = this.getRestRetrofit().listDeviceGroupElements(searchCriteria.getGroupToken(), responseFormat.getIncludeDetails(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceGroupElement> addElementsToDdeviceGroup(ITenantAuthentication tenant, String groupToken, List<DeviceGroupElementCreateRequest> requests) throws SiteWhereException {
        Call<SearchResults<DeviceGroupElement>> call = this.getRestRetrofit().addElementsToDdeviceGroup(groupToken, requests, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceGroupElement> deleteDeviceGroupElements(ITenantAuthentication tenant, String groupToken, List<String> elementIds) throws SiteWhereException {
        Call<SearchResults<DeviceGroupElement>> call = this.getRestRetrofit().deleteDeviceGroupElements(groupToken, elementIds, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceGroupElement> deleteDeviceGroupElement(ITenantAuthentication tenant, String groupToken, String elementId) throws SiteWhereException {
        Call<SearchResults<DeviceGroupElement>> call = this.getRestRetrofit().deleteDeviceGroupElement(groupToken, elementId, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForDeviceGroup(ITenantAuthentication tenant, String groupToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForDeviceGroup(groupToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<DeviceState> listDeviceStates(ITenantAuthentication tenant, DeviceStateSearchCriteria searchCriteria, DeviceStateResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<DeviceState>> call = this.getRestRetrofit().listDeviceStates(searchCriteria, responseFormat.getIncludeArea(), responseFormat.getIncludeAsset(), responseFormat.getIncludeCustomer(), responseFormat.getIncludeDevice(), responseFormat.getIncludeDeviceAssignment(), responseFormat.getIncludeDeviceType(), responseFormat.getIncludeEventDetails(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceStatus> listDeviceStatuses(ITenantAuthentication tenant, DeviceStatusSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<DeviceStatus>> call = this.getRestRetrofit().listDeviceStatuses(searchCriteria.getCode(), searchCriteria.getDeviceTypeToken(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceStatus getDeviceStatusByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceStatus> call = this.getRestRetrofit().getDeviceStatusByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceStatus createDeviceStatus(ITenantAuthentication tenant, DeviceStatusCreateRequest request) throws SiteWhereException {
        Call<DeviceStatus> call = this.getRestRetrofit().createDeviceStatus(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceStatus updateDeviceStatus(ITenantAuthentication tenant, String token, DeviceStatusCreateRequest request) throws SiteWhereException {
        Call<DeviceStatus> call = this.getRestRetrofit().updateDeviceStatus(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceStatus deleteDeviceStatus(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceStatus> call = this.getRestRetrofit().deleteDeviceStatus(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<DeviceType> listDeviceTypes(ITenantAuthentication tenant, DeviceTypeSearchCriteria searchCriteria, DeviceTypeResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<DeviceType>> call = this.getRestRetrofit().listDeviceTypes(responseFormat.getIncludeAsset(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceType getDeviceTypeByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceType> call = this.getRestRetrofit().getDeviceTypeByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceType createDeviceType(ITenantAuthentication tenant, DeviceTypeCreateRequest request) throws SiteWhereException {
        Call<DeviceType> call = this.getRestRetrofit().createDeviceType(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceType updateDeviceType(ITenantAuthentication tenant, String token, DeviceTypeCreateRequest request) throws SiteWhereException {
        Call<DeviceType> call = this.getRestRetrofit().updateDeviceType(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceType deleteDeviceType(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<DeviceType> call = this.getRestRetrofit().deleteDeviceType(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForDeviceType(ITenantAuthentication tenant, String token, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForDeviceType(token, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public String getDeviceTypeGPBSpecification(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getDeviceTypeGPBSpecification(token, this.createHeadersFor(tenant));
        try {
            return new String(this.processRestCall(call).bytes());
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public File downlaodDeviceTypeGPBSpecification(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().downlaodDeviceTypeGPBSpecification(token, this.createHeadersFor(tenant));
        try {
            retrofit2.Response response = call.execute();
            if (response.isSuccessful()) {
                String fileName = SiteWhereClient.extractFileName(response.headers().get(CONTENT_DISPOSITION_HEADER));
                return Files.write(new File(fileName).toPath(), ((ResponseBody)response.body()).bytes(), new OpenOption[0]).toFile();
            }
            throw new SiteWhereException(response.toString());
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public SearchResults<Device> listDevices(ITenantAuthentication tenant, DeviceSearchCriteria searchCriteria, DeviceResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<Device>> call = this.getRestRetrofit().listDevices(searchCriteria.getDeviceTypeToken(), searchCriteria.isExcludeAssigned(), responseFormat.getIncludeAssignment(), responseFormat.getIncludeDeviceType(), this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDevice getDeviceByToken(ITenantAuthentication tenant, String deviceToken) throws SiteWhereException {
        Call<MarshaledDevice> call = this.getRestRetrofit().getDeviceByToken(deviceToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDevice createDevice(ITenantAuthentication tenant, DeviceCreateRequest request) throws SiteWhereException {
        Call<MarshaledDevice> call = this.getRestRetrofit().createDevice(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDevice updateDevice(ITenantAuthentication tenant, String deviceToken, DeviceCreateRequest request) throws SiteWhereException {
        Call<MarshaledDevice> call = this.getRestRetrofit().updateDevice(deviceToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDevice deleteDevice(ITenantAuthentication tenant, String deviceToken) throws SiteWhereException {
        Call<MarshaledDevice> call = this.getRestRetrofit().deleteDevice(deviceToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public DeviceEventBatchResponse addMultipleEventsForDevice(ITenantAuthentication tenant, String deviceToken, DeviceEventBatch batch) throws SiteWhereException {
        Call<DeviceEventBatchResponse> call = this.getRestRetrofit().addMultipleEventsForDevice(deviceToken, batch, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<MarshaledDeviceAssignment> listDeviceAssignmentsForDevice(ITenantAuthentication tenant, String deviceToken, DeviceAssignmentSearchCriteria searchCriteria, DeviceAssignmentResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<MarshaledDeviceAssignment>> call = this.getRestRetrofit().listDeviceAssignmentsForDevice(deviceToken, responseFormat.getIncludeArea(), responseFormat.getIncludeAsset(), responseFormat.getIncludeCustomer(), responseFormat.getIncludeDevice(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public byte[] getLabelForDevice(ITenantAuthentication tenant, String deviceToken, String generatorId) throws SiteWhereException {
        Call<ResponseBody> call = this.getRestRetrofit().getLabelForDevice(deviceToken, generatorId, this.createHeadersFor(tenant));
        try {
            return this.processRestCall(call).bytes();
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public MarshaledDevice createDeviceMappings(ITenantAuthentication tenant, String deviceToken, DeviceElementMapping request) throws SiteWhereException {
        Call<MarshaledDevice> call = this.getRestRetrofit().createDeviceMappings(deviceToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public MarshaledDevice deleteDeviceMappings(ITenantAuthentication tenant, String deviceToken, String path) throws SiteWhereException {
        Call<MarshaledDevice> call = this.getRestRetrofit().deleteDeviceMappings(deviceToken, path, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<Device> listDevicesByDeviceGroup(ITenantAuthentication tenant, String groupToken, DeviceSearchCriteria searchCriteria, DeviceByGroupResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<Device>> call = this.getRestRetrofit().listDevicesByDeviceGroup(groupToken, searchCriteria.getDeviceTypeToken(), searchCriteria.isExcludeAssigned(), responseFormat.getIncludeAssignment(), responseFormat.getIncludeDeleted(), responseFormat.getIncludeDeviceType(), this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<Device> listDevicesByDeviceGroupWithRole(ITenantAuthentication tenant, String role, DeviceSearchCriteria searchCriteria, DeviceByGroupResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<Device>> call = this.getRestRetrofit().listDevicesByDeviceGroupWithRole(role, searchCriteria.getDeviceTypeToken(), searchCriteria.isExcludeAssigned(), responseFormat.getIncludeAssignment(), responseFormat.getIncludeDeleted(), responseFormat.getIncludeDeviceType(), this.toISO8601(searchCriteria.getStartDate()), this.toISO8601(searchCriteria.getEndDate()), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<ScheduledJob> listScheduledJobs(ITenantAuthentication tenant, ScheduledJobSearchCriteria searchCriteria, ScheduledJobResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<ScheduledJob>> call = this.getRestRetrofit().listScheduledJobs(responseFormat.getIncludeContext(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public ScheduledJob getScheduledJobByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<ScheduledJob> call = this.getRestRetrofit().getScheduledJobByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public ScheduledJob createScheduledJob(ITenantAuthentication tenant, ScheduledJobCreateRequest request) throws SiteWhereException {
        Call<ScheduledJob> call = this.getRestRetrofit().createScheduledJob(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public ScheduledJob updateScheduledJob(ITenantAuthentication tenant, String token, ScheduledJobCreateRequest request) throws SiteWhereException {
        Call<ScheduledJob> call = this.getRestRetrofit().updateScheduledJob(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public ScheduledJob deleteScheduledJob(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<ScheduledJob> call = this.getRestRetrofit().deleteScheduledJob(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<Schedule> listSchedules(ITenantAuthentication tenant, ScheduleSearchCriteria searchCriteria, ScheduleResponseFormat responseFormat) throws SiteWhereException {
        Call<SearchResults<Schedule>> call = this.getRestRetrofit().listSchedules(searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Schedule getScheduleByToken(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<Schedule> call = this.getRestRetrofit().getScheduleByToken(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Schedule createSchedule(ITenantAuthentication tenant, ScheduleCreateRequest request) throws SiteWhereException {
        Call<Schedule> call = this.getRestRetrofit().createSchedule(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Schedule updateSchedule(ITenantAuthentication tenant, String token, ScheduleCreateRequest request) throws SiteWhereException {
        Call<Schedule> call = this.getRestRetrofit().updateSchedule(token, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Schedule deleteSchedule(ITenantAuthentication tenant, String token) throws SiteWhereException {
        Call<Schedule> call = this.getRestRetrofit().deleteSchedule(token, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Version getSiteWhereVersion() throws SiteWhereException {
        Call<Version> call = this.getRestRetrofit().getVersion();
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<Tenant> listTenants(TenantSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<Tenant>> call = this.getRestRetrofit().listTenants(searchCriteria.getUserId(), searchCriteria.getTextSearch(), searchCriteria.isIncludeRuntimeInfo(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public Tenant getTenantByToken(String tenantToken) throws SiteWhereException {
        Call<Tenant> call = this.getRestRetrofit().getTenantByToken(tenantToken, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public Tenant createTenant(TenantCreateRequest request) throws SiteWhereException {
        Call<Tenant> call = this.getRestRetrofit().createTenant(request, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public Tenant updateTenant(String tenantToken, TenantCreateRequest request) throws SiteWhereException {
        Call<Tenant> call = this.getRestRetrofit().updateTenant(tenantToken, request, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public Tenant deleteTenant(String tenantToken) throws SiteWhereException {
        Call<Tenant> call = this.getRestRetrofit().deleteTenant(tenantToken, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<User> listUsers() throws SiteWhereException {
        Call<SearchResults<User>> call = this.getRestRetrofit().listUsers(this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public User getUserByUsername(String username) throws SiteWhereException {
        Call<User> call = this.getRestRetrofit().getUserByUsername(username, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public User createUser(UserCreateRequest request) throws SiteWhereException {
        Call<User> call = this.getRestRetrofit().createUser(request, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public User updateUser(String username, UserCreateRequest request) throws SiteWhereException {
        Call<User> call = this.getRestRetrofit().updateUser(username, request, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public User deleteUser(String username) throws SiteWhereException {
        Call<User> call = this.getRestRetrofit().deleteUser(username, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<GrantedAuthority> listUserAuthorities(String username) throws SiteWhereException {
        Call<SearchResults<GrantedAuthority>> call = this.getRestRetrofit().listUserAuthorities(username, this.createDefaulHeaders());
        return this.processRestCall(call);
    }

    @Override
    public SearchResults<Zone> listZones(ITenantAuthentication tenant, ZoneSearchCriteria searchCriteria) throws SiteWhereException {
        Call<SearchResults<Zone>> call = this.getRestRetrofit().listZones(searchCriteria.getAreaToken(), searchCriteria.getPageNumber(), searchCriteria.getPageSize(), this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Zone getZoneByToken(ITenantAuthentication tenant, String zoneToken) throws SiteWhereException {
        Call<Zone> call = this.getRestRetrofit().getZoneByToken(zoneToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Zone createZone(ITenantAuthentication tenant, ZoneCreateRequest request) throws SiteWhereException {
        Call<Zone> call = this.getRestRetrofit().createZone(request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Zone updateZone(ITenantAuthentication tenant, String zoneToken, ZoneCreateRequest request) throws SiteWhereException {
        Call<Zone> call = this.getRestRetrofit().updateZone(zoneToken, request, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    @Override
    public Zone deleteZone(ITenantAuthentication tenant, String zoneToken) throws SiteWhereException {
        Call<Zone> call = this.getRestRetrofit().deleteZone(zoneToken, this.createHeadersFor(tenant));
        return this.processRestCall(call);
    }

    public static ITenantAuthentication defaultTenant() {
        TenantAuthentication auth = new TenantAuthentication();
        auth.setTenantToken("default");
        auth.setTenantAuthToken("sitewhere1234567890");
        return auth;
    }

    public static ITenantAuthentication forTenant(String tenantToken, String tenantAuthToken) {
        TenantAuthentication auth = new TenantAuthentication();
        auth.setTenantToken(tenantToken);
        auth.setTenantAuthToken(tenantAuthToken);
        return auth;
    }

    protected <T> T processRestCall(Call<T> call) throws SiteWhereException {
        try {
            retrofit2.Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            throw new SiteWhereException(response.toString());
        }
        catch (IOException e) {
            throw new SiteWhereException((Throwable)e);
        }
    }

    @Override
    public ISiteWhereClient initialize() throws SiteWhereException {
        Retrofit authRetrofitSettings = new Retrofit.Builder().baseUrl(this.getAuthApiUrl()).client(this.buildBasicAuthClient()).build();
        this.authRetrofit = (AuthenticationRetrofit)authRetrofitSettings.create(AuthenticationRetrofit.class);
        Retrofit restRetrofitSettings = new Retrofit.Builder().baseUrl(this.getRestApiUrl()).client(this.buildGlobalClient()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        this.restRetrofit = (SiteWhereRestRetrofit)restRetrofitSettings.create(SiteWhereRestRetrofit.class);
        try {
            retrofit2.Response jwtResponse = this.getAuthRetrofit().getJwt().execute();
            if (!jwtResponse.isSuccessful()) {
                throw new SiteWhereException("Error obtaining JWT: " + jwtResponse);
            }
            Headers headers = jwtResponse.headers();
            List jwts = headers.values("X-Sitewhere-JWT");
            if (jwts.size() <= 0) {
                throw new SiteWhereException("No JWT returned in server response.");
            }
            this.jwt = (String)jwts.get(0);
            return this;
        }
        catch (IOException e) {
            throw new SiteWhereException("Exception obtaining JWT.", (Throwable)e);
        }
    }

    protected OkHttpClient buildBasicAuthClient() {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", SiteWhereClient.this.getAuthHeader());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
        return httpClient.build();
    }

    protected OkHttpClient buildGlobalClient() {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", "Bearer " + SiteWhereClient.this.jwt);
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        });
        return httpClient.build();
    }

    protected Map<String, String> createHeadersFor(ITenantAuthentication tenant) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-SiteWhere-Tenant-Id", tenant.getTenantToken());
        headers.put("X-SiteWhere-Tenant-Auth", tenant.getTenantAuthToken());
        return headers;
    }

    protected Map<String, String> createDefaulHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        return headers;
    }

    protected String getSearchCriteriaFields(SearchCriteria criteria) {
        String result = "page={page}&pageSize={pageSize}";
        if (criteria instanceof DateRangeSearchCriteria) {
            DateRangeSearchCriteria dates = (DateRangeSearchCriteria)criteria;
            if (dates.getStartDate() != null) {
                result = result + "&startDate={startDate}";
            }
            if (dates.getEndDate() != null) {
                result = result + "&endDate={endDate}";
            }
        }
        return result;
    }

    protected void addSearchCriteria(Map<String, String> vars, SearchCriteria criteria) {
        if (criteria != null) {
            if (criteria.getPageNumber() != null) {
                vars.put("page", String.valueOf(criteria.getPageNumber()));
            }
            if (criteria.getPageSize() != null) {
                vars.put("pageSize", String.valueOf(criteria.getPageSize()));
            }
        }
        if (criteria instanceof DateRangeSearchCriteria) {
            DateRangeSearchCriteria dates = (DateRangeSearchCriteria)criteria;
            if (dates.getStartDate() != null) {
                vars.put("startDate", JsonDateSerializer.serialize((Date)dates.getStartDate()));
            }
            if (dates.getEndDate() != null) {
                vars.put("endDate", JsonDateSerializer.serialize((Date)dates.getEndDate()));
            }
        }
    }

    protected String getRestApiUrl() {
        return this.getProtocol() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort()) + REST_RELATIVE_URL;
    }

    protected String getAuthApiUrl() {
        return this.getProtocol() + "://" + this.getHostname() + ":" + String.valueOf(this.getPort()) + AUTH_RELATIVE_URL;
    }

    protected String getAuthHeader() {
        String token = this.getUsername() + ":" + this.getPassword();
        String encoded = new String(Base64.encode(token.getBytes()));
        return "Basic " + encoded;
    }

    protected String toISO8601(Date date) {
        if (date == null) {
            return "";
        }
        return iso8601DateFormat.format(date);
    }

    protected static String assembleTokenList(List<String> tokenList) {
        if (tokenList == null || tokenList.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (String token : tokenList) {
            builder.append(sep);
            builder.append(token);
            sep = ", ";
        }
        return builder.toString();
    }

    protected static <T> String assembleList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (T token : list) {
            builder.append(sep);
            builder.append(token.toString());
            sep = ", ";
        }
        return builder.toString();
    }

    private static String extractFileName(String content) {
        if (content == null || content.isEmpty()) {
            return "file.name";
        }
        int index = content.indexOf("filename=");
        if (index == -1) {
            return "file.name";
        }
        String filename = content.substring(index + 9);
        return filename;
    }

    public AuthenticationRetrofit getAuthRetrofit() {
        return this.authRetrofit;
    }

    public void setAuthRetrofit(AuthenticationRetrofit authRetrofit) {
        this.authRetrofit = authRetrofit;
    }

    public SiteWhereRestRetrofit getRestRetrofit() {
        return this.restRetrofit;
    }

    public void setRestRetrofit(SiteWhereRestRetrofit restRetrofit) {
        this.restRetrofit = restRetrofit;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getJwt() {
        return this.jwt;
    }

    public void setJwt(String jwt) {
        this.jwt = jwt;
    }

    public static class Builder {
        private SiteWhereClient client = new SiteWhereClient();

        public ISiteWhereClient build() {
            return this.client;
        }

        public Builder withConnectionTo(String protocol, String hostname, int port) {
            this.client.setProtocol(protocol);
            this.client.setHostname(hostname);
            this.client.setPort(port);
            return this;
        }

        public Builder forUser(String username, String password) {
            this.client.setUsername(username);
            this.client.setPassword(password);
            return this;
        }
    }
}

