/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.area;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.Location;
import com.sitewhere.rest.model.common.PersistentEntity;
import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.area.IZone;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Zone
extends PersistentEntity
implements IZone {
    private static final long serialVersionUID = 7526239754356991844L;
    private UUID areaId;
    private String name;
    private List<Location> bounds = new ArrayList<Location>();
    private String borderColor;
    private Double borderOpacity;
    private String fillColor;
    private Double fillOpacity;

    @Override
    public UUID getAreaId() {
        return this.areaId;
    }

    public void setAreaId(UUID areaId) {
        this.areaId = areaId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Location> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<Location> bounds) {
        this.bounds = bounds;
    }

    @Override
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public Double getBorderOpacity() {
        return this.borderOpacity;
    }

    public void setBorderOpacity(Double borderOpacity) {
        this.borderOpacity = borderOpacity;
    }

    @Override
    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public Double getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(Double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public static Zone copy(IZone input) throws SiteWhereException {
        Zone result = new Zone();
        result.setId(input.getId());
        result.setToken(input.getToken());
        result.setAreaId(input.getAreaId());
        result.setName(input.getName());
        result.setCreatedDate(input.getCreatedDate());
        result.setBorderColor(input.getBorderColor());
        result.setBorderOpacity(input.getBorderOpacity());
        result.setFillColor(input.getFillColor());
        result.setFillOpacity(input.getFillOpacity());
        result.setBounds(Location.copy(input.getBounds()));
        PersistentEntity.copy(input, result);
        return result;
    }
}

