/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.area.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.Location;
import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.area.request.IAreaCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AreaCreateRequest
extends BrandedEntityCreateRequest
implements IAreaCreateRequest {
    private static final long serialVersionUID = 2232101100201358496L;
    public String areaTypeToken;
    public String parentToken;
    private String name;
    private String description;
    private List<Location> bounds = new ArrayList<Location>();

    @Override
    public String getAreaTypeToken() {
        return this.areaTypeToken;
    }

    public void setAreaTypeToken(String areaTypeToken) {
        this.areaTypeToken = areaTypeToken;
    }

    @Override
    public String getParentToken() {
        return this.parentToken;
    }

    public void setParentToken(String parentToken) {
        this.parentToken = parentToken;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Location> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<Location> bounds) {
        this.bounds = bounds;
    }

    public static class Builder {
        private AreaCreateRequest request = new AreaCreateRequest();

        public Builder(String areaTypeToken, String parentToken, String token, String name) {
            this.request.setAreaTypeToken(areaTypeToken);
            this.request.setParentToken(parentToken);
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setDescription("");
            this.request.setImageUrl("https://s3.amazonaws.com/sitewhere-demo/broken-link.png");
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder coord(double latitude, double longitude) {
            this.request.getBounds().add(new Location(latitude, longitude));
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public AreaCreateRequest build() {
            return this.request;
        }
    }
}

