/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.area.request;

import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.area.IAreaType;
import com.sitewhere.spi.area.request.IAreaTypeCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AreaTypeCreateRequest
extends BrandedEntityCreateRequest
implements IAreaTypeCreateRequest {
    private static final long serialVersionUID = 7654388850917582565L;
    private String name;
    private String description;
    private List<String> containedAreaTypeTokens;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getContainedAreaTypeTokens() {
        return this.containedAreaTypeTokens;
    }

    public void setContainedAreaTypeTokens(List<String> containedAreaTypeTokens) {
        this.containedAreaTypeTokens = containedAreaTypeTokens;
    }

    public static class Builder {
        private AreaTypeCreateRequest request = new AreaTypeCreateRequest();

        public Builder(IAreaType api) {
            this.request.setToken(api.getToken());
            this.request.setName(api.getName());
            this.request.setDescription(api.getDescription());
            this.request.setIcon(api.getIcon());
            if (api.getMetadata() != null) {
                this.request.setMetadata(new HashMap<String, String>());
                this.request.getMetadata().putAll(api.getMetadata());
            }
        }

        public Builder(String token, String name) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setDescription("");
            this.request.setIcon("fa-question");
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withIcon(String icon) {
            this.request.setIcon(icon);
            return this;
        }

        public Builder withContainedAreaType(String areaTypeToken) {
            if (this.request.getContainedAreaTypeTokens() == null) {
                this.request.setContainedAreaTypeTokens(new ArrayList<String>());
            }
            this.request.getContainedAreaTypeTokens().add(areaTypeToken);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public AreaTypeCreateRequest build() {
            return this.request;
        }
    }
}

