/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.area.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.Location;
import com.sitewhere.rest.model.common.request.PersistentEntityCreateRequest;
import com.sitewhere.spi.area.IArea;
import com.sitewhere.spi.area.request.IZoneCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ZoneCreateRequest
extends PersistentEntityCreateRequest
implements IZoneCreateRequest {
    private static final long serialVersionUID = -2226478978161539653L;
    private String areaToken;
    private String name;
    private List<Location> bounds = new ArrayList<Location>();
    private String borderColor;
    private Double borderOpacity;
    private String fillColor;
    private Double fillOpacity;

    @Override
    public String getAreaToken() {
        return this.areaToken;
    }

    public void setAreaToken(String areaToken) {
        this.areaToken = areaToken;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Location> getBounds() {
        return this.bounds;
    }

    public void setBounds(List<Location> bounds) {
        this.bounds = bounds;
    }

    @Override
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public Double getBorderOpacity() {
        return this.borderOpacity;
    }

    public void setBorderOpacity(Double borderOpacity) {
        this.borderOpacity = borderOpacity;
    }

    @Override
    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public Double getFillOpacity() {
        return this.fillOpacity;
    }

    public void setFillOpacity(Double fillOpacity) {
        this.fillOpacity = fillOpacity;
    }

    public static class Builder {
        private ZoneCreateRequest request = new ZoneCreateRequest();

        public Builder(String token, String name, IArea area) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setAreaToken(area.getToken());
        }

        public Builder withBorderColor(String borderColor) {
            this.request.setBorderColor(borderColor);
            return this;
        }

        public Builder withBorderOpacity(double opacity) {
            this.request.setBorderOpacity(opacity);
            return this;
        }

        public Builder withFillColor(String fillColor) {
            this.request.setFillColor(fillColor);
            return this;
        }

        public Builder withFillOpacity(double opacity) {
            this.request.setFillOpacity(opacity);
            return this;
        }

        public Builder coord(double latitude, double longitude) {
            this.request.getBounds().add(new Location(latitude, longitude));
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public ZoneCreateRequest build() {
            return this.request;
        }
    }
}

