/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.asset.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.asset.request.IAssetCreateRequest;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetCreateRequest
extends BrandedEntityCreateRequest
implements IAssetCreateRequest {
    private static final long serialVersionUID = -3557255561907642778L;
    private String assetTypeToken;
    private String name;

    @Override
    public String getAssetTypeToken() {
        return this.assetTypeToken;
    }

    public void setAssetTypeToken(String assetTypeToken) {
        this.assetTypeToken = assetTypeToken;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class Builder {
        private AssetCreateRequest request = new AssetCreateRequest();

        public Builder(String token, String assetTypeToken, String name) {
            this.request.setToken(token);
            this.request.setAssetTypeToken(assetTypeToken);
            this.request.setName(name);
            this.request.setImageUrl("https://s3.amazonaws.com/sitewhere-demo/broken-link.png");
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public AssetCreateRequest build() {
            return this.request;
        }
    }
}

