/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.asset.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.asset.AssetCategory;
import com.sitewhere.spi.asset.request.IAssetTypeCreateRequest;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssetTypeCreateRequest
extends BrandedEntityCreateRequest
implements IAssetTypeCreateRequest {
    private static final long serialVersionUID = 4980888004733279548L;
    private String name;
    private String description;
    private AssetCategory assetCategory;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public AssetCategory getAssetCategory() {
        return this.assetCategory;
    }

    public void setAssetCategory(AssetCategory assetCategory) {
        this.assetCategory = assetCategory;
    }

    public static class Builder {
        private AssetTypeCreateRequest request = new AssetTypeCreateRequest();

        public Builder(String token, String name) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setAssetCategory(AssetCategory.Hardware);
            this.request.setImageUrl("https://s3.amazonaws.com/sitewhere-demo/broken-link.png");
        }

        public Builder asHardware() {
            this.request.setAssetCategory(AssetCategory.Hardware);
            return this;
        }

        public Builder asPerson() {
            this.request.setAssetCategory(AssetCategory.Person);
            return this;
        }

        public Builder asDevice() {
            this.request.setAssetCategory(AssetCategory.Device);
            return this;
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public AssetTypeCreateRequest build() {
            return this.request;
        }
    }
}

