/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.batch.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.PersistentEntityCreateRequest;
import com.sitewhere.spi.batch.request.IBatchCommandInvocationRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BatchCommandInvocationRequest
extends PersistentEntityCreateRequest
implements IBatchCommandInvocationRequest {
    private static final long serialVersionUID = -8215264923380389864L;
    private String deviceTypeToken;
    private String commandToken;
    private Map<String, String> parameterValues = new HashMap<String, String>();
    private List<String> deviceTokens;

    @Override
    public String getDeviceTypeToken() {
        return this.deviceTypeToken;
    }

    public void setDeviceTypeToken(String deviceTypeToken) {
        this.deviceTypeToken = deviceTypeToken;
    }

    @Override
    public String getCommandToken() {
        return this.commandToken;
    }

    public void setCommandToken(String commandToken) {
        this.commandToken = commandToken;
    }

    @Override
    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, String> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public List<String> getDeviceTokens() {
        return this.deviceTokens;
    }

    public void setDeviceTokens(List<String> deviceTokens) {
        this.deviceTokens = deviceTokens;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private BatchCommandInvocationRequest build = new BatchCommandInvocationRequest();

        private Builder() {
            this.withToken(UUID.randomUUID().toString());
        }

        public Builder withToken(String token) {
            this.build.setToken(token);
            return this;
        }

        public Builder withDeviceTypeToken(String deviceTypeToken) {
            this.build.setDeviceTypeToken(deviceTypeToken);
            return this;
        }

        public Builder withCommandToken(String commandToken) {
            this.build.setCommandToken(commandToken);
            return this;
        }

        public Builder withDeviceTokens(List<String> deviceTokens) {
            if (this.build.getDeviceTokens() == null) {
                this.build.setDeviceTokens(new ArrayList<String>());
            }
            this.build.getDeviceTokens().addAll(deviceTokens);
            return this;
        }

        public Builder withDeviceToken(String deviceToken) {
            this.withDeviceTokens(Collections.singletonList(deviceToken));
            return this;
        }

        public Builder withParameter(String name, String value) {
            this.build.getParameterValues().put(name, value);
            return this;
        }

        public BatchCommandInvocationRequest build() {
            return this.build;
        }
    }
}

