/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.common;

import com.sitewhere.spi.common.ILocation;
import java.util.ArrayList;
import java.util.List;

public class Location
implements ILocation {
    private static final long serialVersionUID = 7247443984993993837L;
    private Double latitude;
    private Double longitude;
    private Double elevation;

    public Location() {
    }

    public Location(Double latitude, Double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = 0.0;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public Double getElevation() {
        return this.elevation;
    }

    public void setElevation(Double elevation) {
        this.elevation = elevation;
    }

    public static Location copy(ILocation input) {
        Location result = new Location();
        result.setLatitude(input.getLatitude());
        result.setLongitude(input.getLongitude());
        result.setElevation(input.getElevation());
        return result;
    }

    public static List<Location> copy(List<? extends ILocation> input) {
        if (input == null || input.size() == 0) {
            return null;
        }
        ArrayList<Location> result = new ArrayList<Location>();
        for (ILocation iLocation : input) {
            result.add(Location.copy(iLocation));
        }
        return result;
    }
}

