/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.common;

import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.SiteWhereSystemException;
import com.sitewhere.spi.common.IMetadataProvider;
import com.sitewhere.spi.error.ErrorCode;
import com.sitewhere.spi.error.ErrorLevel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MetadataProvider
implements IMetadataProvider,
Serializable {
    private static final long serialVersionUID = -7708181397230364294L;
    private Map<String, String> metadata = new HashMap<String, String>();

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static void copy(IMetadataProvider source, MetadataProvider target) throws SiteWhereException {
        if (source != null) {
            MetadataProvider.copy(source.getMetadata(), target);
        }
    }

    public static void copy(Map<String, String> source, MetadataProvider target) throws SiteWhereException {
        if (source != null) {
            for (String key : source.keySet()) {
                if (!key.matches("^[\\w-]+$")) {
                    throw new SiteWhereSystemException(ErrorCode.InvalidMetadataFieldName, ErrorLevel.ERROR);
                }
                target.getMetadata().put(key, source.get(key));
            }
        }
    }
}

