/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.customer.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.customer.request.ICustomerCreateRequest;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CustomerCreateRequest
extends BrandedEntityCreateRequest
implements ICustomerCreateRequest {
    private static final long serialVersionUID = -1744483793661325449L;
    public String customerTypeToken;
    public String parentToken;
    private String name;
    private String description;

    @Override
    public String getCustomerTypeToken() {
        return this.customerTypeToken;
    }

    public void setCustomerTypeToken(String customerTypeToken) {
        this.customerTypeToken = customerTypeToken;
    }

    @Override
    public String getParentToken() {
        return this.parentToken;
    }

    public void setParentToken(String parentToken) {
        this.parentToken = parentToken;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class Builder {
        private CustomerCreateRequest request = new CustomerCreateRequest();

        public Builder(String customerTypeToken, String parentToken, String token, String name) {
            this.request.setCustomerTypeToken(customerTypeToken);
            this.request.setParentToken(parentToken);
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setDescription("");
            this.request.setImageUrl("https://s3.amazonaws.com/sitewhere-demo/broken-link.png");
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public CustomerCreateRequest build() {
            return this.request;
        }
    }
}

