/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.customer.request;

import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.customer.ICustomerType;
import com.sitewhere.spi.customer.request.ICustomerTypeCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomerTypeCreateRequest
extends BrandedEntityCreateRequest
implements ICustomerTypeCreateRequest {
    private static final long serialVersionUID = 2776911532638550509L;
    private String name;
    private String description;
    private List<String> containedCustomerTypeTokens;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getContainedCustomerTypeTokens() {
        return this.containedCustomerTypeTokens;
    }

    public void setContainedCustomerTypeTokens(List<String> containedCustomerTypeTokens) {
        this.containedCustomerTypeTokens = containedCustomerTypeTokens;
    }

    public static class Builder {
        private CustomerTypeCreateRequest request = new CustomerTypeCreateRequest();

        public Builder(ICustomerType api) {
            this.request.setToken(api.getToken());
            this.request.setName(api.getName());
            this.request.setDescription(api.getDescription());
            this.request.setIcon(api.getIcon());
            if (api.getMetadata() != null) {
                this.request.setMetadata(new HashMap<String, String>());
                this.request.getMetadata().putAll(api.getMetadata());
            }
        }

        public Builder(String token, String name) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setDescription("");
            this.request.setIcon("fa-question");
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withIcon(String icon) {
            this.request.setIcon(icon);
            return this;
        }

        public Builder withContainedCustomerType(String customerTypeToken) {
            if (this.request.getContainedCustomerTypeTokens() == null) {
                this.request.setContainedCustomerTypeTokens(new ArrayList<String>());
            }
            this.request.getContainedCustomerTypeTokens().add(customerTypeToken);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public CustomerTypeCreateRequest build() {
            return this.request;
        }
    }
}

