/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.command;

import com.sitewhere.rest.model.common.PersistentEntity;
import com.sitewhere.rest.model.device.command.CommandParameter;
import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.device.command.ICommandParameter;
import com.sitewhere.spi.device.command.IDeviceCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DeviceCommand
extends PersistentEntity
implements IDeviceCommand {
    private static final long serialVersionUID = -9098150828821813365L;
    private UUID deviceTypeId;
    private String namespace;
    private String name;
    private String description;
    private List<CommandParameter> parameters = new ArrayList<CommandParameter>();

    @Override
    public UUID getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public void setDeviceTypeId(UUID deviceTypeId) {
        this.deviceTypeId = deviceTypeId;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<ICommandParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<CommandParameter> parameters) {
        this.parameters = parameters;
    }

    public static DeviceCommand copy(IDeviceCommand input) throws SiteWhereException {
        DeviceCommand result = new DeviceCommand();
        PersistentEntity.copy(input, result);
        result.setId(input.getId());
        result.setToken(input.getToken());
        result.setDeviceTypeId(input.getDeviceTypeId());
        result.setName(input.getName());
        result.setNamespace(input.getNamespace());
        result.setDescription(input.getDescription());
        for (ICommandParameter inparam : input.getParameters()) {
            CommandParameter param = new CommandParameter();
            param.setName(inparam.getName());
            param.setType(inparam.getType());
            param.setRequired(inparam.isRequired());
            result.getParameters().add(param);
        }
        return result;
    }
}

