/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.event.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.device.event.request.DeviceEventCreateRequest;
import com.sitewhere.spi.device.event.AlertLevel;
import com.sitewhere.spi.device.event.AlertSource;
import com.sitewhere.spi.device.event.DeviceEventType;
import com.sitewhere.spi.device.event.request.IDeviceAlertCreateRequest;
import java.io.Serializable;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceAlertCreateRequest
extends DeviceEventCreateRequest
implements IDeviceAlertCreateRequest,
Serializable {
    private static final long serialVersionUID = 7660473778731839384L;
    private AlertSource source = AlertSource.Device;
    private AlertLevel level = AlertLevel.Info;
    private String type;
    private String message;

    public DeviceAlertCreateRequest() {
        this.setEventType(DeviceEventType.Alert);
    }

    @Override
    public AlertSource getSource() {
        return this.source;
    }

    public void setSource(AlertSource source) {
        this.source = source;
    }

    @Override
    public AlertLevel getLevel() {
        return this.level;
    }

    public void setLevel(AlertLevel level) {
        this.level = level;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static class Builder
    extends DeviceEventCreateRequest.Builder<DeviceAlertCreateRequest> {
        private DeviceAlertCreateRequest request = new DeviceAlertCreateRequest();

        public Builder(String type, String message) {
            this.request.setType(type);
            this.request.setMessage(message);
            this.request.setSource(AlertSource.Device);
            this.request.setLevel(AlertLevel.Info);
        }

        public Builder asSystemAlert() {
            this.request.setSource(AlertSource.System);
            return this;
        }

        public Builder warning() {
            this.request.setLevel(AlertLevel.Warning);
            return this;
        }

        public Builder error() {
            this.request.setLevel(AlertLevel.Error);
            return this;
        }

        public Builder critical() {
            this.request.setLevel(AlertLevel.Critical);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        @Override
        public DeviceAlertCreateRequest getRequest() {
            return this.request;
        }

        @Override
        public DeviceAlertCreateRequest build() {
            return this.request;
        }
    }
}

