/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.event.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.device.event.request.DeviceEventCreateRequest;
import com.sitewhere.spi.device.event.DeviceEventType;
import com.sitewhere.spi.device.event.request.IDeviceLocationCreateRequest;
import java.io.Serializable;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceLocationCreateRequest
extends DeviceEventCreateRequest
implements IDeviceLocationCreateRequest,
Serializable {
    private static final long serialVersionUID = -7160866457228082338L;
    private Double latitude;
    private Double longitude;
    private Double elevation;

    public DeviceLocationCreateRequest() {
        this.setEventType(DeviceEventType.Location);
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @Override
    public Double getElevation() {
        return this.elevation;
    }

    public void setElevation(Double elevation) {
        this.elevation = elevation;
    }

    public static class Builder
    extends DeviceEventCreateRequest.Builder<DeviceLocationCreateRequest> {
        private DeviceLocationCreateRequest request = new DeviceLocationCreateRequest();

        public Builder(double latitude, double longitude) {
            this.request.setLatitude(latitude);
            this.request.setLongitude(longitude);
            this.request.setElevation(0.0);
        }

        public Builder withElevation(double value) {
            this.request.setElevation(value);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        @Override
        public DeviceLocationCreateRequest getRequest() {
            return this.request;
        }

        @Override
        public DeviceLocationCreateRequest build() {
            return this.request;
        }
    }
}

