/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.event.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.device.event.request.DeviceEventCreateRequest;
import com.sitewhere.spi.device.event.DeviceEventType;
import com.sitewhere.spi.device.event.request.IDeviceMeasurementCreateRequest;
import java.util.HashMap;

@JsonIgnoreProperties
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceMeasurementCreateRequest
extends DeviceEventCreateRequest
implements IDeviceMeasurementCreateRequest {
    private static final long serialVersionUID = 9193083760712267587L;
    private String name;
    private double value;

    public DeviceMeasurementCreateRequest() {
        this.setEventType(DeviceEventType.Measurement);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public static class Builder
    extends DeviceEventCreateRequest.Builder<DeviceMeasurementCreateRequest> {
        private DeviceMeasurementCreateRequest request = new DeviceMeasurementCreateRequest();

        public Builder measurement(String name, double value) {
            this.request.setName(name);
            this.request.setValue(value);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        @Override
        public DeviceMeasurementCreateRequest getRequest() {
            return this.request;
        }

        @Override
        public DeviceMeasurementCreateRequest build() {
            return this.request;
        }
    }
}

