/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.event.scripting;

import com.sitewhere.spi.device.IDeviceAssignment;
import com.sitewhere.spi.device.event.DeviceEventType;
import com.sitewhere.spi.device.event.IDeviceAlert;
import com.sitewhere.spi.device.event.IDeviceEvent;

public class DeviceEventSupport {
    private IDeviceAssignment deviceAssignment;
    private IDeviceEvent event;

    public DeviceEventSupport(IDeviceAssignment deviceAssignment, IDeviceEvent event) {
        this.deviceAssignment = deviceAssignment;
        this.event = event;
    }

    public boolean isLocation() {
        return this.event.getEventType() == DeviceEventType.Location;
    }

    public boolean isMeasurement() {
        return this.event.getEventType() == DeviceEventType.Measurement;
    }

    public boolean isCommandInvocation() {
        return this.event.getEventType() == DeviceEventType.CommandInvocation;
    }

    public boolean isCommandResponse() {
        return this.event.getEventType() == DeviceEventType.CommandResponse;
    }

    public boolean isAlert() {
        return this.event.getEventType() == DeviceEventType.Alert;
    }

    public boolean isAlertOfType(String type) {
        return this.isAlert() && ((IDeviceAlert)this.event).getType().equals(type);
    }

    public IDeviceAssignment getDeviceAssignment() {
        return this.deviceAssignment;
    }

    public void setDeviceAssignment(IDeviceAssignment deviceAssignment) {
        this.deviceAssignment = deviceAssignment;
    }

    public IDeviceEvent data() {
        return this.event;
    }

    public IDeviceEvent getData() {
        return this.event;
    }
}

