/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.spi.device.DeviceAlarmState;
import com.sitewhere.spi.device.request.IDeviceAlarmCreateRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceAlarmCreateRequest
implements IDeviceAlarmCreateRequest {
    private static final long serialVersionUID = -5830937120265421555L;
    private String deviceAssignmentToken;
    private String alarmMessage;
    private UUID triggeringEventId;
    private DeviceAlarmState state;
    private Date triggeredDate;
    private Date acknowledgedDate;
    private Date resolvedDate;
    private Map<String, String> metadata;

    @Override
    public String getDeviceAssignmentToken() {
        return this.deviceAssignmentToken;
    }

    public void setDeviceAssignmentToken(String deviceAssignmentToken) {
        this.deviceAssignmentToken = deviceAssignmentToken;
    }

    @Override
    public String getAlarmMessage() {
        return this.alarmMessage;
    }

    public void setAlarmMessage(String alarmMessage) {
        this.alarmMessage = alarmMessage;
    }

    @Override
    public UUID getTriggeringEventId() {
        return this.triggeringEventId;
    }

    public void setTriggeringEventId(UUID triggeringEventId) {
        this.triggeringEventId = triggeringEventId;
    }

    @Override
    public DeviceAlarmState getState() {
        return this.state;
    }

    public void setState(DeviceAlarmState state) {
        this.state = state;
    }

    @Override
    public Date getTriggeredDate() {
        return this.triggeredDate;
    }

    public void setTriggeredDate(Date triggeredDate) {
        this.triggeredDate = triggeredDate;
    }

    @Override
    public Date getAcknowledgedDate() {
        return this.acknowledgedDate;
    }

    public void setAcknowledgedDate(Date acknowledgedDate) {
        this.acknowledgedDate = acknowledgedDate;
    }

    @Override
    public Date getResolvedDate() {
        return this.resolvedDate;
    }

    public void setResolvedDate(Date resolvedDate) {
        this.resolvedDate = resolvedDate;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static class Builder {
        private DeviceAlarmCreateRequest request = new DeviceAlarmCreateRequest();

        public Builder(String deviceAssignmentToken, String alarmMessage) {
            this.request.setDeviceAssignmentToken(deviceAssignmentToken);
            this.request.setAlarmMessage(alarmMessage);
            this.request.setState(DeviceAlarmState.Triggered);
        }

        public Builder withTriggeringEventId(UUID eventId) {
            this.request.setTriggeringEventId(eventId);
            return this;
        }

        public Builder withTriggeredState() {
            this.request.setState(DeviceAlarmState.Triggered);
            return this;
        }

        public Builder withAcknowledgedState() {
            this.request.setState(DeviceAlarmState.Acknowledged);
            return this;
        }

        public Builder withResolvedState() {
            this.request.setState(DeviceAlarmState.Resolved);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public DeviceAlarmCreateRequest build() {
            return this.request;
        }
    }
}

