/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.PersistentEntityCreateRequest;
import com.sitewhere.rest.model.device.command.CommandParameter;
import com.sitewhere.spi.device.command.ICommandParameter;
import com.sitewhere.spi.device.command.ParameterType;
import com.sitewhere.spi.device.request.IDeviceCommandCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceCommandCreateRequest
extends PersistentEntityCreateRequest
implements IDeviceCommandCreateRequest {
    private static final long serialVersionUID = 7791276552702413783L;
    private String deviceTypeToken;
    private String namespace;
    private String name;
    private String description;
    private List<CommandParameter> parameters = new ArrayList<CommandParameter>();

    @Override
    public String getDeviceTypeToken() {
        return this.deviceTypeToken;
    }

    public void setDeviceTypeToken(String deviceTypeToken) {
        this.deviceTypeToken = deviceTypeToken;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<ICommandParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<CommandParameter> parameters) {
        this.parameters = parameters;
    }

    public static class Builder {
        private DeviceCommandCreateRequest request = new DeviceCommandCreateRequest();

        public Builder(String deviceTypeToken, String token, String namespace, String name) {
            this.request.setDeviceTypeToken(deviceTypeToken);
            this.request.setToken(token);
            this.request.setNamespace(namespace);
            this.request.setName(name);
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withStringParameter(String name, boolean required) {
            this.request.getParameters().add(new CommandParameter(name, ParameterType.String, required));
            return this;
        }

        public Builder withIntParameter(String name, boolean required) {
            this.request.getParameters().add(new CommandParameter(name, ParameterType.Int64, required));
            return this;
        }

        public Builder withDoubleParameter(String name, boolean required) {
            this.request.getParameters().add(new CommandParameter(name, ParameterType.Double, required));
            return this;
        }

        public Builder withBooleanParameter(String name, boolean required) {
            this.request.getParameters().add(new CommandParameter(name, ParameterType.Bool, required));
            return this;
        }

        public Builder withParameter(String name, ParameterType type, boolean required) {
            this.request.getParameters().add(new CommandParameter(name, type, required));
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public DeviceCommandCreateRequest build() {
            return this.request;
        }
    }
}

