/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.spi.device.group.IDeviceGroup;
import com.sitewhere.spi.device.request.IDeviceGroupCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceGroupCreateRequest
extends BrandedEntityCreateRequest
implements IDeviceGroupCreateRequest {
    private static final long serialVersionUID = 1657559631108464556L;
    private String name;
    private String description;
    private List<String> roles;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public static class Builder {
        private DeviceGroupCreateRequest request = new DeviceGroupCreateRequest();

        public Builder(IDeviceGroup api) {
            this.request.setToken(api.getToken());
            this.request.setName(api.getName());
            this.request.setDescription(api.getDescription());
            if (this.request.getRoles() != null) {
                this.request.setRoles(new ArrayList<String>());
                this.request.getRoles().addAll(api.getRoles());
            }
            if (api.getMetadata() != null) {
                this.request.setMetadata(new HashMap<String, String>());
                this.request.getMetadata().putAll(api.getMetadata());
            }
        }

        public Builder(String token, String name) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setImageUrl("https://s3.amazonaws.com/sitewhere-demo/broken-link.png");
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder withRole(String role) {
            if (this.request.getRoles() == null) {
                this.request.setRoles(new ArrayList<String>());
            }
            this.request.getRoles().add(role);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public DeviceGroupCreateRequest build() {
            return this.request;
        }
    }
}

