/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.device.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.BrandedEntityCreateRequest;
import com.sitewhere.rest.model.device.element.DeviceElementSchema;
import com.sitewhere.rest.model.device.element.DeviceSlot;
import com.sitewhere.rest.model.device.element.DeviceUnit;
import com.sitewhere.spi.device.DeviceContainerPolicy;
import com.sitewhere.spi.device.element.IDeviceElementSchema;
import com.sitewhere.spi.device.request.IDeviceTypeCreateRequest;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DeviceTypeCreateRequest
extends BrandedEntityCreateRequest
implements IDeviceTypeCreateRequest {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private DeviceContainerPolicy containerPolicy;
    private DeviceElementSchema deviceElementSchema;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public DeviceContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public void setContainerPolicy(DeviceContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    @Override
    public IDeviceElementSchema getDeviceElementSchema() {
        return this.deviceElementSchema;
    }

    public void setDeviceElementSchema(DeviceElementSchema deviceElementSchema) {
        this.deviceElementSchema = deviceElementSchema;
    }

    public static class DeviceUnitBuilder {
        private DeviceUnit unit = new DeviceUnit();

        public DeviceUnitBuilder(String name, String path) {
            this.unit.setName(name);
            this.unit.setPath(path);
        }

        public DeviceUnitBuilder addUnit(String name, String path) {
            DeviceUnitBuilder sub = new DeviceUnitBuilder(name, path);
            this.unit.getDeviceUnits().add(sub.build());
            return sub;
        }

        public DeviceUnitBuilder addSlot(String name, String path) {
            DeviceSlot slot = new DeviceSlot();
            slot.setName(name);
            slot.setPath(path);
            this.unit.getDeviceSlots().add(slot);
            return this;
        }

        public DeviceUnit build() {
            return this.unit;
        }
    }

    public static class DeviceElementSchemaBuilder {
        private DeviceElementSchema schema = new DeviceElementSchema();

        public DeviceUnitBuilder addUnit(String name, String path) {
            DeviceUnitBuilder unit = new DeviceUnitBuilder(name, path);
            this.schema.getDeviceUnits().add(unit.build());
            return unit;
        }

        public DeviceElementSchemaBuilder addSlot(String name, String path) {
            DeviceSlot slot = new DeviceSlot();
            slot.setName(name);
            slot.setPath(path);
            this.schema.getDeviceSlots().add(slot);
            return this;
        }

        public DeviceElementSchema build() {
            return this.schema;
        }
    }

    public static class Builder {
        private DeviceTypeCreateRequest request = new DeviceTypeCreateRequest();

        public Builder(String token, String name) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setContainerPolicy(DeviceContainerPolicy.Standalone);
            this.request.setImageUrl("https://s3.amazonaws.com/sitewhere-demo/broken-link.png");
        }

        public Builder withDescription(String description) {
            this.request.setDescription(description);
            return this;
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder makeComposite() {
            this.request.setContainerPolicy(DeviceContainerPolicy.Composite);
            return this;
        }

        public DeviceElementSchemaBuilder newSchema() {
            DeviceElementSchemaBuilder schema = new DeviceElementSchemaBuilder();
            this.request.setDeviceElementSchema(schema.build());
            return schema;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public DeviceTypeCreateRequest build() {
            return this.request;
        }
    }
}

