/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.scheduling.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.rest.model.common.request.PersistentEntityCreateRequest;
import com.sitewhere.spi.scheduling.ISchedule;
import com.sitewhere.spi.scheduling.TriggerType;
import com.sitewhere.spi.scheduling.request.IScheduleCreateRequest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ScheduleCreateRequest
extends PersistentEntityCreateRequest
implements IScheduleCreateRequest {
    private static final long serialVersionUID = 1453554726838184776L;
    private String name;
    private TriggerType triggerType;
    private Map<String, String> triggerConfiguration;
    private Date startDate;
    private Date endDate;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TriggerType getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
    }

    @Override
    public Map<String, String> getTriggerConfiguration() {
        return this.triggerConfiguration;
    }

    public void setTriggerConfiguration(Map<String, String> triggerConfiguration) {
        this.triggerConfiguration = triggerConfiguration;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public static class Builder {
        private ScheduleCreateRequest request = new ScheduleCreateRequest();

        public Builder(ISchedule schedule) {
            this.request.setToken(schedule.getToken());
            this.request.setName(schedule.getName());
            this.request.setTriggerType(schedule.getTriggerType());
            this.request.setTriggerConfiguration(schedule.getTriggerConfiguration());
            this.request.setStartDate(schedule.getStartDate());
            this.request.setEndDate(schedule.getEndDate());
            this.request.setMetadata(schedule.getMetadata());
        }

        public Builder(String name) {
            this(UUID.randomUUID().toString(), name);
        }

        public Builder(String token, String name) {
            this.request.setToken(token);
            this.request.setName(name);
        }

        public Builder withSimpleSchedule(Long interval, Integer count) {
            this.request.setTriggerType(TriggerType.SimpleTrigger);
            HashMap<String, String> config = new HashMap<String, String>();
            if (interval != null) {
                config.put("repeatInterval", String.valueOf(interval));
            }
            if (count != null) {
                config.put("repeatCount", String.valueOf(count));
            }
            this.request.setTriggerConfiguration(config);
            return this;
        }

        public Builder withCronSchedule(String cronExpression) {
            this.request.setTriggerType(TriggerType.CronTrigger);
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("cronExpression", cronExpression);
            this.request.setTriggerConfiguration(config);
            return this;
        }

        public Builder withStartDate(Date startDate) {
            this.request.setStartDate(startDate);
            return this;
        }

        public Builder withEndDate(Date endDate) {
            this.request.setEndDate(endDate);
            return this;
        }

        public ScheduleCreateRequest build() {
            return this.request;
        }
    }
}

