/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.search;

import com.sitewhere.spi.search.ISearchCriteria;
import java.util.ArrayList;
import java.util.List;

public class Pager<T> {
    private List<T> results = new ArrayList<T>();
    private ISearchCriteria criteria;
    private long toSkip;
    private long matched;
    private long total;

    public Pager(ISearchCriteria criteria) {
        this.criteria = criteria;
        this.toSkip = criteria.getPageNumber() >= 1 ? (long)((criteria.getPageNumber() - 1) * criteria.getPageSize()) : 0L;
        this.total = 0L;
    }

    public void process(T record) {
        ++this.total;
        if (this.toSkip > 0L) {
            --this.toSkip;
        } else if (this.criteria.getPageSize() == 0 || this.matched < (long)this.criteria.getPageSize().intValue()) {
            this.results.add(record);
            ++this.matched;
        }
    }

    public ISearchCriteria getSearchCriteria() {
        return this.criteria;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }

    public long getTotal() {
        return this.total;
    }
}

