/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.tenant.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sitewhere.spi.tenant.ITenant;
import com.sitewhere.spi.tenant.request.ITenantCreateRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TenantCreateRequest
implements ITenantCreateRequest {
    private static final long serialVersionUID = -5706275554835627264L;
    private String token;
    private String name;
    private String authenticationToken;
    private List<String> authorizedUserIds;
    private String configurationTemplateId;
    private String datasetTemplateId;
    private String backgroundColor;
    private String foregroundColor;
    private String borderColor;
    private String icon;
    private String imageUrl;
    private Map<String, String> metadata;

    @Override
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    @Override
    public List<String> getAuthorizedUserIds() {
        return this.authorizedUserIds;
    }

    public void setAuthorizedUserIds(List<String> authorizedUserIds) {
        this.authorizedUserIds = authorizedUserIds;
    }

    @Override
    public String getConfigurationTemplateId() {
        return this.configurationTemplateId;
    }

    public void setConfigurationTemplateId(String configurationTemplateId) {
        this.configurationTemplateId = configurationTemplateId;
    }

    @Override
    public String getDatasetTemplateId() {
        return this.datasetTemplateId;
    }

    public void setDatasetTemplateId(String datasetTemplateId) {
        this.datasetTemplateId = datasetTemplateId;
    }

    @Override
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public String getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(String foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    @Override
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static class Builder {
        private TenantCreateRequest request = new TenantCreateRequest();

        public Builder(String token, String name, String authenticationToken, String logoUrl, String configurationTemplateId, String datasetTemplateId) {
            this.request.setToken(token);
            this.request.setName(name);
            this.request.setAuthenticationToken(authenticationToken);
            this.request.setImageUrl(logoUrl);
            this.request.setConfigurationTemplateId(configurationTemplateId);
            this.request.setDatasetTemplateId(datasetTemplateId);
        }

        public Builder(ITenant existing) {
            this.request.setToken(existing.getToken());
            this.request.setName(existing.getName());
            this.request.setImageUrl(existing.getImageUrl());
            this.request.setAuthenticationToken(existing.getAuthenticationToken());
            this.request.setAuthorizedUserIds(existing.getAuthorizedUserIds());
            this.request.setConfigurationTemplateId(existing.getConfigurationTemplateId());
            this.request.setDatasetTemplateId(existing.getDatasetTemplateId());
            this.request.setMetadata(existing.getMetadata());
        }

        public Builder withBackgroundColor(String color) {
            this.request.setBackgroundColor(color);
            return this;
        }

        public Builder withForegroundColor(String color) {
            this.request.setForegroundColor(color);
            return this;
        }

        public Builder withBorderColor(String color) {
            this.request.setBorderColor(color);
            return this;
        }

        public Builder withIcon(String icon) {
            this.request.setIcon(icon);
            return this;
        }

        public Builder withImageUrl(String imageUrl) {
            this.request.setImageUrl(imageUrl);
            return this;
        }

        public Builder withAuthorizedUserId(String userId) {
            if (this.request.getAuthorizedUserIds() == null) {
                this.request.setAuthorizedUserIds(new ArrayList<String>());
            }
            this.request.getAuthorizedUserIds().add(userId);
            return this;
        }

        public Builder metadata(String name, String value) {
            if (this.request.getMetadata() == null) {
                this.request.setMetadata(new HashMap<String, String>());
            }
            this.request.getMetadata().put(name, value);
            return this;
        }

        public TenantCreateRequest build() {
            return this.request;
        }
    }
}

