/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.user;

import com.sitewhere.rest.model.user.GrantedAuthorityHierarchyNode;
import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.user.IGrantedAuthority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GrantedAuthorityHierarchyBuilder {
    public static List<GrantedAuthorityHierarchyNode> build(List<IGrantedAuthority> auths) throws SiteWhereException {
        ArrayList<GrantedAuthorityHierarchyNode> results = new ArrayList<GrantedAuthorityHierarchyNode>();
        ArrayList<IGrantedAuthority> roots = new ArrayList<IGrantedAuthority>();
        for (IGrantedAuthority auth : auths) {
            if (auth.getParent() != null) continue;
            roots.add(auth);
        }
        if (roots.size() == 0) {
            throw new SiteWhereException("No root authorities found.");
        }
        for (IGrantedAuthority root : roots) {
            auths.remove(root);
            GrantedAuthorityHierarchyNode node = GrantedAuthorityHierarchyBuilder.create(root);
            GrantedAuthorityHierarchyBuilder.addChildren(node, auths);
            results.add(node);
        }
        Collections.sort(results);
        return results;
    }

    protected static void addChildren(GrantedAuthorityHierarchyNode node, List<IGrantedAuthority> auths) {
        ArrayList<IGrantedAuthority> matches = new ArrayList<IGrantedAuthority>();
        for (IGrantedAuthority auth : auths) {
            if (!node.getId().equals(auth.getParent())) continue;
            matches.add(auth);
        }
        for (IGrantedAuthority match : matches) {
            auths.remove(match);
        }
        for (IGrantedAuthority match : matches) {
            GrantedAuthorityHierarchyNode child = GrantedAuthorityHierarchyBuilder.create(match);
            GrantedAuthorityHierarchyBuilder.addChildren(child, auths);
            node.getItems().add(child);
        }
        Collections.sort(node.getItems());
    }

    protected static GrantedAuthorityHierarchyNode create(IGrantedAuthority auth) {
        GrantedAuthorityHierarchyNode node = new GrantedAuthorityHierarchyNode();
        node.setId(auth.getAuthority());
        node.setText(auth.getDescription());
        node.setGroup(auth.isGroup());
        return node;
    }
}

