/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.rest.model.user;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.sitewhere.rest.model.common.PersistentEntity;
import com.sitewhere.rest.model.datatype.JsonDateSerializer;
import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.user.AccountStatus;
import com.sitewhere.spi.user.IUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
extends PersistentEntity
implements IUser {
    private static final long serialVersionUID = -3322129570954465956L;
    private String username;
    private String hashedPassword;
    private String firstName;
    private String lastName;
    private Date lastLogin;
    private AccountStatus status;
    private List<String> authorities = new ArrayList<String>();

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getHashedPassword() {
        return this.hashedPassword;
    }

    public void setHashedPassword(String hashedPassword) {
        this.hashedPassword = hashedPassword;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    @JsonSerialize(using=JsonDateSerializer.class)
    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date lastLogin) {
        this.lastLogin = lastLogin;
    }

    @Override
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    @Override
    public List<String> getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(List<String> authorities) {
        this.authorities = authorities;
    }

    public static User copy(IUser input) throws SiteWhereException {
        User result = new User();
        result.setUsername(input.getUsername());
        result.setHashedPassword(input.getHashedPassword());
        result.setFirstName(input.getFirstName());
        result.setLastName(input.getLastName());
        result.setLastLogin(input.getLastLogin());
        result.setStatus(input.getStatus());
        result.setAuthorities(new ArrayList<String>(input.getAuthorities()));
        PersistentEntity.copy(input, result);
        return result;
    }
}

