/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.spi.device.util;

import com.sitewhere.spi.SiteWhereException;
import com.sitewhere.spi.SiteWhereSystemException;
import com.sitewhere.spi.device.IDeviceType;
import com.sitewhere.spi.device.element.IDeviceElement;
import com.sitewhere.spi.device.element.IDeviceSlot;
import com.sitewhere.spi.device.element.IDeviceUnit;
import com.sitewhere.spi.error.ErrorCode;
import com.sitewhere.spi.error.ErrorLevel;
import java.util.ArrayDeque;
import java.util.Arrays;

public class DeviceTypeUtils {
    public static IDeviceSlot getDeviceSlotByPath(IDeviceType deviceType, String path) throws SiteWhereException {
        IDeviceElement match = DeviceTypeUtils.getDeviceElementByPath(deviceType, path);
        if (match == null || !(match instanceof IDeviceSlot)) {
            throw new SiteWhereSystemException(ErrorCode.InvalidDeviceSlotPath, ErrorLevel.ERROR);
        }
        return (IDeviceSlot)match;
    }

    public static IDeviceElement getDeviceElementByPath(IDeviceType deviceType, String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] segarray = path.split("[/]");
        ArrayDeque<String> segments = new ArrayDeque<String>(Arrays.asList(segarray));
        IDeviceUnit unit = deviceType.getDeviceElementSchema();
        if (unit == null) {
            return null;
        }
        block0: while (segments.size() > 0) {
            String segment = (String)segments.poll();
            if (segments.size() > 0) {
                for (IDeviceUnit nested : unit.getDeviceUnits()) {
                    if (!nested.getPath().equals(segment)) continue;
                    unit = nested;
                    continue block0;
                }
                continue;
            }
            for (IDeviceSlot slot : unit.getDeviceSlots()) {
                if (!slot.getPath().equals(segment)) continue;
                return slot;
            }
            for (IDeviceUnit nested : unit.getDeviceUnits()) {
                if (!nested.getPath().equals(segment)) continue;
                return nested;
            }
            return null;
        }
        return null;
    }
}

