/*
 * Decompiled with CFR 0.152.
 */
package com.sitewhere.spi.error;

public enum ErrorCode {
    Error(1L, "Generic application error."),
    OperationNotPermitted(5L, "User does not have permission for this operation."),
    InvalidMetadataFieldName(10L, "Metadata field name contains invalid characters."),
    InvalidMicroserviceIdentifier(500L, "Microservice identifier was not recognized."),
    InvalidUsername(1000L, "Username does not exist."),
    InvalidPassword(1010L, "Password did not match."),
    DuplicateUser(1020L, "Username already in use."),
    InvalidUserInformation(1030L, "Missing required fields for user."),
    InvalidAuthority(1040L, "Authority does not exist"),
    DuplicateAuthority(1050L, "Authority name already in use."),
    NotLoggedIn(1060L, "You must provide credentials to perform this action."),
    InvalidTenantAuthToken(1070L, "Tenant not found for authentication token."),
    MissingTenantAuthToken(1080L, "Tenant authentication token required for request."),
    NotAuthorizedForTenant(1090L, "Not authorized to view information for tenant."),
    InvalidTenantEngineId(1100L, "Tenant engine does not exist."),
    InvalidTenantId(1110L, "Tenant does not exist."),
    InvalidTenantToken(1120L, "Tenant does not exist."),
    TenantAlreadyStarted(3000L, "Tenant was already started."),
    TenantAlreadyStopped(3010L, "Tenant was already stopped."),
    TenantIdFormat(3020L, "Tenant id should be an alphanumeric value with no spaces."),
    DuplicateCustomerTypeToken(4000L, "Customer type token already in use."),
    InvalidCustomerTypeToken(4002L, "Customer type not found."),
    DuplicateCustomerToken(4005L, "Customer token already in use."),
    InvalidCustomerToken(4007L, "Customer not found."),
    MalformedHardwareId(4010L, "Hardware id must consist of alphanumeric values with dashes, underscores, and no spaces."),
    DuplicateId(4020L, "The given id is already in use."),
    DuplicateDeviceToken(4030L, "Device token already in use."),
    InvalidDeviceToken(4040L, "Device token not found."),
    InvalidDeviceId(4050L, "Device id not found."),
    InvalidDeviceTypeToken(4060L, "Device type not found."),
    DuplicateDeviceTypeToken(4070L, "Device type token already in use."),
    InvalidDeviceCommandToken(4080L, "Device command not found."),
    InvalidDeviceCommandId(4090L, "Device command not found."),
    InvalidDeviceStatusId(4100L, "Device status not found."),
    InvalidDeviceStatusToken(4105L, "Device status not found."),
    DuplicateAreaTypeToken(4110L, "Area type token already in use."),
    DuplicateAreaToken(4120L, "Area token already in use."),
    InvalidAreaToken(4130L, "Area not found."),
    InvalidAreaTypeToken(4140L, "Area type not found."),
    DuplicateDeviceAssignment(4150L, "Device assignment token already in use."),
    InvalidDeviceAssignmentId(4160L, "Device assignment not found."),
    InvalidDeviceAssignmentToken(4170L, "Device assignment token not found."),
    InvalidDeviceAlarmId(4050L, "Device alarm id not found."),
    InvalidZoneToken(4180L, "Zone not found."),
    InvalidDeviceEventId(4190L, "Device event not found for id."),
    InvalidSearchProviderId(4200L, "Search provider not found."),
    DuplicateStreamId(4210L, "Device assignment has an existing stream with the given id."),
    InvalidStreamId(4220L, "Device assignment does not have an existing stream with the given id."),
    InvalidCharsInStreamId(4230L, "Stream id contains invalid characters."),
    InvalidAssetTypeToken(4240L, "Asset type token not found."),
    InvalidAssetTypeId(4250L, "Asset type not found."),
    InvalidAssetToken(4260L, "Asset token not found."),
    InvalidAssetId(4270L, "Asset not found."),
    DuplicateTenantId(4280L, "Tenant id already in use."),
    DuplicateTenantGroupId(4290L, "Tenant group id already in use."),
    InvalidScheduleToken(4300L, "Schedule not found."),
    InvalidScheduledJobToken(4310L, "Scheduled job not found."),
    DuplicateScheduleToken(4320L, "Schedule token already in use."),
    DuplicateScheduledJobToken(4330L, "Scheduled job token already in use."),
    InvalidTenantTemplateId(4340L, "Tenant template not found"),
    DuplicateZoneToken(4350L, "Zone token already in use."),
    DuplicateBatchOperationToken(4360L, "Batch operation token already in use."),
    DuplicateBatchElement(4370L, "Batch element already in use."),
    DuplicateDeviceGroupToken(4380L, "Device group token already in use."),
    InvalidDeviceGroupToken(4390L, "Device group not found."),
    InvalidDeviceGroupId(4400L, "Device group not found."),
    InvalidBatchOperationId(4410L, "Batch operation not found."),
    InvalidBatchOperationToken(4420L, "Batch operation not found."),
    InvalidBatchElementId(4430L, "Batch element not found."),
    InvalidDeviceStateId(4440L, "Device state id not found."),
    DeviceCommandExists(5000L, "Device command with same namespace and name already exists for specification."),
    DeviceStatusExists(6000L, "Device status with same code already exists for specification."),
    CanNotDeleteActiveAssignment(7000L, "Can not delete an active device assignment."),
    DeviceTypeInUseByDevices(7500L, "Device type can not be deleted. One or more devices are currently using this device type."),
    DeviceAlreadyAssigned(8000L, "Device already has an active assignment."),
    DeviceNotAssigned(8010L, "Device is not currently assigned."),
    DeviceHardwareIdCanNotBeChanged(8020L, "Device hardware id can not be updated."),
    DeviceCanNotBeDeletedIfAssigned(8030L, "Device can not be deleted if it is currently assigned."),
    DeviceSiteCanNotBeChangedIfAssigned(8040L, "Device site can not be changed if it is currently assigned."),
    DeviceElementMappingExists(8050L, "Device has an existing mapping for the given device element schema path."),
    DeviceElementMappingDoesNotExist(8060L, "Device element mapping does not exist."),
    InvalidDeviceSlotPath(8070L, "Path does not correspond to a valid device slot."),
    DeviceParentMappingExists(8080L, "Target device is already in use by an existing mapping."),
    DeviceDeleteHasAssignments(8090L, "Unable to delete device. One or more device assignments reference this device."),
    RequiredCommandParameterMissing(9000L, "Invocation does not specify a parameter marked as required."),
    RequiredCommandParameterValueMissing(9010L, "Invocation does not assign a value to a required parameter."),
    ZoneDeleteFailed(10000L, "Unable to delete zoned."),
    AssetTypeTokenInUse(11000L, "Asset type token is already in use."),
    AssetTokenInUse(11010L, "Asset token is already in use."),
    AssetTypeNoDeleteHasAssets(11020L, "Unable to delete asset type. One or more assets reference this asset type."),
    AssetNoDeleteHasAssignments(11500L, "Unable to delete asset. One or more device assignments reference this asset."),
    LabelGeneratorNotFound(12000L, "The requested label generator was not found."),
    GenericDeleteFailed(13000L, "Delete unsuccessful."),
    IncompleteData(13010L, "Not all required data was provided."),
    Unknown(99999L, "Unknown error.");

    private long code;
    private String message;

    private ErrorCode(long code, String message) {
        this.setCode(code);
        this.setMessage(message);
    }

    public static ErrorCode fromCode(long code) {
        for (ErrorCode current : ErrorCode.values()) {
            if (current.getCode() != code) continue;
            return current;
        }
        throw new RuntimeException("Invalid error code: " + code);
    }

    public void setCode(long code) {
        this.code = code;
    }

    public long getCode() {
        return this.code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

