/*
 * Decompiled with CFR 0.152.
 */
package com.slickqa.executioner.executable;

import com.slickqa.executioner.cmdlineagent.CommandLineAgentVerticle;
import com.slickqa.executioner.dummyagent.DummyAgentVerticle;
import com.slickqa.executioner.web.ExecutionerWebVerticle;
import com.slickqa.executioner.workqueue.ExecutionerWorkQueueVerticle;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DeployVerticle
extends AbstractVerticle {
    private boolean[] webVerticleStarted;
    private FileSystem fs;
    private EventBus eventBus;
    private Logger log;
    private String locationOfAgents;
    private String agentImagesDirectory;
    private Map<String, JsonObject> redeploy;
    private Map<String, JsonObject> agents;
    private int dummyAgentCounter;

    protected boolean allWebVerticleStarted() {
        for (boolean individual : this.webVerticleStarted) {
            if (individual) continue;
            return false;
        }
        return true;
    }

    public boolean deployAgent(JsonObject config) {
        String name = config.getString("name");
        if (name == null) {
            this.log.error((Object)"Trying to deploy an agent without a name, must be a bug.  JSON={0}", new Object[]{config.encodePrettily()});
        } else {
            String type = config.getString("type", "DummyAgent");
            DeploymentOptions options = new DeploymentOptions();
            options.setConfig(config);
            DummyAgentVerticle agent = null;
            if ("DummyAgent".equalsIgnoreCase(type)) {
                if (!config.containsKey("agentNumber")) {
                    config = config.put("agentNumber", Integer.valueOf(++this.dummyAgentCounter));
                }
                agent = new DummyAgentVerticle();
            } else if ("CommandLineAgent".equalsIgnoreCase(type)) {
                agent = new CommandLineAgentVerticle();
            } else if (config.getString("className") != null) {
                try {
                    Class<?> agentClass = Class.forName(config.getString("className"));
                    if (!Verticle.class.isAssignableFrom(agentClass)) {
                        this.log.error((Object)"Class {0} for agent {1} is not a Verticle! Config: {2}", new Object[]{config.getString("className"), name, config.encodePrettily()});
                        return false;
                    }
                    agent = (Verticle)agentClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    this.log.error((Object)("Problem when trying to deploy an agent with class " + config.getString("className") + " from config: " + config.encodePrettily()), (Throwable)e);
                    return false;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.log.error((Object)("Problem when trying to instantiate agent " + name + "'s class " + config.getString("className") + ": "), (Throwable)e);
                    e.printStackTrace();
                }
            }
            if (agent != null) {
                this.vertx.deployVerticle((Verticle)agent, options);
                this.agents.put(name, config);
                return true;
            }
        }
        return false;
    }

    public boolean deployConnector(JsonObject config) {
        String connectorClassName = config.getString("className", null);
        if (connectorClassName == null) {
            this.log.error((Object)"Connector config className missing from connector config: {0}", new Object[]{config.encodePrettily()});
            return false;
        }
        Class<?> connector = null;
        try {
            connector = ((Object)((Object)this)).getClass().getClassLoader().loadClass(connectorClassName);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Unable to load class '" + connectorClassName + "': "), (Throwable)e);
            return false;
        }
        if (!AbstractVerticle.class.isAssignableFrom(connector)) {
            this.log.error((Object)"Connector class {0} is not a Verticle, we can't deploy it!", new Object[]{connectorClassName});
            return false;
        }
        AbstractVerticle instance = null;
        try {
            instance = (AbstractVerticle)connector.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.log.error((Object)("Error creating instance of connector class '" + connectorClassName + "': "), (Throwable)e);
            return false;
        }
        DeploymentOptions options = new DeploymentOptions().setConfig(config);
        this.vertx.deployVerticle((Verticle)instance, options);
        return true;
    }

    public void loadAgents(Long id) {
        HashSet loaded = new HashSet();
        HashSet pathsLoaded = new HashSet();
        this.fs.readDir(this.locationOfAgents, readDirResult -> {
            if (readDirResult.succeeded()) {
                this.log.info((Object)"Starting load of agents from {0}.", new Object[]{this.locationOfAgents});
                for (String path : (List)readDirResult.result()) {
                    if (!path.endsWith(".json")) continue;
                    this.fs.readFile(path, readFileResult -> {
                        pathsLoaded.add(path);
                        if (readFileResult.succeeded()) {
                            String agentName;
                            JsonObject config = new JsonObject(((Buffer)readFileResult.result()).toString());
                            if (!config.containsKey("name")) {
                                String name = path.substring(path.lastIndexOf(47) + 1);
                                name = name.substring(0, name.length() - 5);
                                config = config.put("name", name);
                            }
                            if (!this.agents.containsKey(agentName = config.getString("name"))) {
                                this.log.info((Object)"Attempting to deploy {0}", new Object[]{agentName});
                                if (this.deployAgent(config)) {
                                    loaded.add(agentName);
                                } else {
                                    this.log.error((Object)"Unable to deploy agent {0} with json: {1}", new Object[]{agentName, config.encodePrettily()});
                                }
                            } else if (!config.equals((Object)this.agents.get(agentName))) {
                                this.log.info((Object)"config {0} does not equal {1}", new Object[]{config.encodePrettily(), this.agents.get(agentName).encodePrettily()});
                                loaded.add(agentName);
                                this.redeploy.put(agentName, config);
                                this.eventBus.send("executioner.agent.stop." + agentName, null);
                            } else {
                                loaded.add(agentName);
                            }
                        } else {
                            this.log.error((Object)"Unable to read file {0}");
                        }
                        if (pathsLoaded.containsAll((Collection)readDirResult.result())) {
                            HashSet<String> toUnload = new HashSet<String>(this.agents.keySet());
                            toUnload.removeAll(loaded);
                            for (String agentNameToUnload : toUnload) {
                                this.log.info((Object)"Unloading agent {0}", new Object[]{agentNameToUnload});
                                this.eventBus.send("executioner.agent.stop." + agentNameToUnload, null);
                            }
                        }
                    });
                }
            } else {
                this.log.error((Object)("Unable to load agents from directory [" + this.locationOfAgents + "] : "), readDirResult.cause());
            }
        });
    }

    public void cleanupImages(Long id) {
        this.log.info((Object)"Cleanup of agent-images started.");
        this.fs.readDir(this.agentImagesDirectory, topLevelDirResponse -> {
            for (String dir : (List)topLevelDirResponse.result()) {
                this.fs.readDir(dir, agentDirResponse -> {
                    if (agentDirResponse.succeeded()) {
                        for (String imagePath : (List)agentDirResponse.result()) {
                            this.fs.props(imagePath, imagePropertyResponse -> {
                                if (imagePropertyResponse.succeeded()) {
                                    if (LocalDateTime.now().minusSeconds(10L).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() > ((FileProps)imagePropertyResponse.result()).lastModifiedTime()) {
                                        this.log.info((Object)"Cleaning up {0}", new Object[]{imagePath});
                                        this.fs.delete(imagePath, deleteResult -> {
                                            if (deleteResult.failed()) {
                                                this.log.warn((Object)"Unable to delete {0}", new Object[]{imagePath});
                                            }
                                        });
                                    }
                                } else {
                                    this.log.warn((Object)("Could not get the properties of " + imagePath + ": "), imagePropertyResponse.cause());
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    public void start(Future<Void> startFuture) {
        this.dummyAgentCounter = 0;
        this.redeploy = new HashMap<String, JsonObject>();
        this.agents = new HashMap<String, JsonObject>();
        this.log = LoggerFactory.getLogger(DeployVerticle.class);
        this.fs = this.vertx.fileSystem();
        this.eventBus = this.vertx.eventBus();
        this.log.info((Object)"Starting Work Queue.");
        JsonObject config = this.vertx.getOrCreateContext().config();
        int numberOfWebVerticles = config.getInteger("webVerticles", Integer.valueOf(4));
        this.locationOfAgents = config.getString("agentsDir", "conf.d");
        this.agentImagesDirectory = config.getString("agentImagesDir", "agent-images");
        int cleanupImagesEvery = config.getInteger("cleanupImagesEvery", Integer.valueOf(10));
        int checkAgentsEvery = config.getInteger("checkAgentsEvery", Integer.valueOf(60));
        this.webVerticleStarted = new boolean[numberOfWebVerticles];
        for (int i = 0; i < numberOfWebVerticles; ++i) {
            this.webVerticleStarted[i] = false;
        }
        this.eventBus.consumer("executioner.agent.delete", message -> {
            Object body = message.body();
            if (body instanceof JsonObject) {
                JsonObject agent = (JsonObject)body;
                this.log.info((Object)"Undeploying agent {0} with deployment id {1}", new Object[]{agent.getString("name"), agent.getString("deploymentId")});
                this.vertx.undeploy(agent.getString("deploymentId"), whenFinished -> {
                    if (whenFinished.succeeded()) {
                        this.agents.remove(agent.getString("name"));
                        if (this.redeploy.containsKey(agent.getString("name"))) {
                            this.log.info((Object)"Redeploying agent {0}", new Object[]{agent.getString("name")});
                            JsonObject agentConfig = this.redeploy.remove(agent.getString("name"));
                            this.deployAgent(agentConfig);
                        } else {
                            this.log.info((Object)"Undeployment of agent {0} finished, have a nice day!", new Object[]{agent.getString("name")});
                        }
                    } else {
                        this.log.error((Object)("Undeployment of agent " + agent.getString("name") + "failed: "), whenFinished.cause());
                    }
                });
            } else {
                this.log.error((Object)"Recieved unknown type ({0}) for message delete announce: ", new Object[]{body.getClass().getName(), body.toString()});
            }
        });
        DeploymentOptions options = new DeploymentOptions();
        options.setConfig(config);
        this.vertx.deployVerticle((Verticle)new ExecutionerWorkQueueVerticle(), options, onFinished -> {
            if (onFinished.succeeded()) {
                int i = 0;
                while (i < numberOfWebVerticles) {
                    int verticleNum = i++;
                    this.vertx.deployVerticle((Verticle)new ExecutionerWebVerticle(), options, result -> {
                        this.webVerticleStarted[verticleNum] = true;
                        if (this.allWebVerticleStarted()) {
                            this.log.info((Object)"All {0} web verticles started.", new Object[]{numberOfWebVerticles});
                            startFuture.complete();
                        }
                    });
                }
            } else {
                this.log.error((Object)"Starting WorkQueue Failed: ", onFinished.cause());
                startFuture.fail(onFinished.cause());
            }
        });
        this.loadAgents(0L);
        for (Object connectorConfig : config.getJsonArray("connectors", new JsonArray())) {
            if (!(connectorConfig instanceof JsonObject)) continue;
            this.deployConnector((JsonObject)connectorConfig);
        }
        this.vertx.setPeriodic((long)(cleanupImagesEvery * 1000), this::cleanupImages);
        this.vertx.setPeriodic((long)(checkAgentsEvery * 1000), this::loadAgents);
    }
}

