/*
 * Decompiled with CFR 0.152.
 */
package com.slickqa.executioner.workqueue;

import com.google.inject.Inject;
import com.slickqa.executioner.base.AutoloadComponent;
import com.slickqa.executioner.base.OnStartup;
import com.slickqa.executioner.workqueue.WorkQueueConfiguration;
import com.slickqa.executioner.workqueue.WorkQueueItem;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@AutoloadComponent
public class WorkQueue
implements OnStartup {
    public static final String NameKey = "name";
    public static final String ProvidesKey = "provides";
    private Vertx vertx;
    private EventBus eventBus;
    private WorkQueueConfiguration config;
    private LocalDateTime broadcastAfter;
    private List<WorkQueueItem> workQueue;
    private Logger log;
    private boolean stopped;

    @Inject
    public WorkQueue(Vertx vertx, EventBus eventBus, WorkQueueConfiguration config) {
        this.eventBus = eventBus;
        this.config = config;
        this.vertx = vertx;
        this.workQueue = new ArrayList<WorkQueueItem>(config.getWorkQueueSize());
        this.log = LoggerFactory.getLogger(WorkQueue.class);
        this.stopped = false;
    }

    public void onStartup() {
        this.resetBroadcastAfter();
        this.vertx.setPeriodic((long)(this.config.getWorkQueueBroadcastInterval() / 3 * 1000), id -> {
            if (LocalDateTime.now().isAfter(this.broadcastAfter)) {
                this.publishQueueInfo();
            }
        });
        this.eventBus.consumer("executioner.workqueue.add").handler(this::addToWorkQueueHandler);
        this.eventBus.consumer("executioner.workqueue.query").handler(message -> message.reply((Object)this.workQueueMessage()));
        this.eventBus.consumer("executioner.workqueue.requestAssignment").handler(this::requestWorkHandler);
        this.eventBus.consumer("executioner.workqueue.stop").handler(message -> {
            this.stopped = true;
            message.reply((Object)new JsonObject().put("stopped", Boolean.valueOf(this.stopped)));
        });
        this.eventBus.consumer("executioner.workqueue.start").handler(message -> {
            this.stopped = false;
            message.reply((Object)new JsonObject().put("stopped", Boolean.valueOf(this.stopped)));
            this.publishQueueInfo();
        });
    }

    private JsonArray workQueueMessage() {
        JsonArray retval = new JsonArray();
        for (WorkQueueItem item : this.workQueue) {
            retval = retval.add(item.toJsonObject());
        }
        return retval;
    }

    private void resetBroadcastAfter() {
        this.broadcastAfter = LocalDateTime.now().plusSeconds(this.config.getWorkQueueBroadcastInterval());
    }

    public void publishQueueInfo() {
        this.log.info((Object)"Publishing Work Queue.");
        this.eventBus.publish("executioner.workqueue.info", (Object)this.workQueueMessage());
        this.resetBroadcastAfter();
    }

    public void addToWorkQueueHandler(Message<Object> message) {
        if (message.body() instanceof JsonArray) {
            for (Object item : (JsonArray)message.body()) {
                if (item instanceof JsonObject) {
                    this.workQueue.add(0, new WorkQueueItem((JsonObject)item));
                    message.reply((Object)this.workQueueMessage());
                    continue;
                }
                this.log.error((Object)"Unable to add item of type {0} to work queue.", new Object[]{item.getClass().getName()});
            }
        } else if (message.body() instanceof JsonObject) {
            this.workQueue.add(0, new WorkQueueItem((JsonObject)message.body()));
            message.reply((Object)this.workQueueMessage());
        } else {
            this.log.error((Object)"Unknown message body type({0}): {1}", new Object[]{message.body().getClass().getName(), message.body()});
        }
        this.publishQueueInfo();
    }

    public void requestWorkHandler(Message<Object> message) {
        Object body = message.body();
        if (this.stopped) {
            message.fail(5, "Work Stopped");
        } else if (this.workQueue.size() == 0) {
            message.fail(10, "No work available");
        } else if (body instanceof JsonObject) {
            JsonObject request = (JsonObject)body;
            if (!request.containsKey(NameKey)) {
                message.fail(20, "Must include a name of the agent in order to request work.");
            } else {
                int itemToAssign = -1;
                JsonArray requestProvides = request.getJsonArray(ProvidesKey);
                if (requestProvides == null) {
                    requestProvides = new JsonArray();
                }
                HashSet<String> provides = new HashSet<String>(requestProvides.size());
                for (Object item : requestProvides) {
                    if (item instanceof String) {
                        provides.add((String)item);
                        continue;
                    }
                    this.log.warn((Object)"Unknown provider type ({0}): {1}", new Object[]{item.getClass().getName(), item.toString()});
                }
                for (int i = this.workQueue.size() - 1; i >= 0; --i) {
                    Object item;
                    item = this.workQueue.get(i);
                    if (!provides.containsAll(((WorkQueueItem)item).getRequirements())) continue;
                    itemToAssign = i;
                    break;
                }
                if (itemToAssign >= 0) {
                    WorkQueueItem assignment = this.workQueue.remove(itemToAssign);
                    message.reply((Object)assignment.toJsonObject());
                    this.publishQueueInfo();
                } else {
                    message.fail(30, "No matching work available.");
                }
            }
        }
    }
}

