/*
 * Decompiled with CFR 0.152.
 */
package com.slickqa.executioner.workqueue;

import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Set;

public class WorkQueueItem {
    public static final String KeyRequirements = "requirements";
    private JsonObject source;
    private Set<String> requirements;
    private static Logger log = LoggerFactory.getLogger(WorkQueueItem.class);

    public WorkQueueItem(JsonObject source) {
        this.source = source;
        this.requirements = new HashSet<String>();
        this.generateRequirements();
    }

    private void generateRequirements() {
        if (this.source != null && this.source.getJsonArray(KeyRequirements) != null) {
            for (Object item : this.source.getJsonArray(KeyRequirements)) {
                if (item instanceof String) {
                    this.requirements.add((String)item);
                    continue;
                }
                log.warn((Object)"Unknown type ({0}) for requirements: {1}", new Object[]{item.getClass().getName(), item.toString()});
            }
        } else {
            log.warn((Object)"No requirements for work queue item: {0}", new Object[]{Json.encodePrettily((Object)this.source)});
        }
    }

    public Set<String> getRequirements() {
        return this.requirements;
    }

    public JsonObject toJsonObject() {
        return this.source;
    }
}

