package com.slimpay;

import java.util.logging.Logger;

public class Config {
	protected final static Logger LOGGER = Logger.getLogger("SlimPay REST API"); 
	
	public static String entryPoint;
	public static String halProfile;
	public static String appId;
	public static String appSecret;
	
	protected Config() {
		
	}
	
	public static String getEntryPoint() {
		return entryPoint;
	}

	public static void setEntryPoint(String entryPoint) {
		Config.entryPoint = entryPoint;
	}

	public static String getHalProfile() {
		return halProfile;
	}

	public static void setHalProfile(String halProfile) {
		Config.halProfile = halProfile;
	}

	public static String getAppId() {
		return appId;
	}

	public static void setAppId(String appId) {
		Config.appId = appId;
	}

	public static String getAppSecret() {
		return appSecret;
	}

	public static void setAppSecret(String appSecret) {
		Config.appSecret = appSecret;
	}

	public static void validate() {
		if (entryPoint == null || entryPoint.isEmpty())
			throw new IllegalArgumentException("Entry point can't be empty");
		else {
			String host = null;
			try {
				host = new java.net.URI(entryPoint.toLowerCase()).getHost();
			} catch (java.net.URISyntaxException e) { }
			
			if (host == null || !host.contains("slimpay"))
				throw new IllegalArgumentException("Entry point doesn't seem to be pointing to a SlimPay server");
		}
		
		if (halProfile == null || halProfile.isEmpty())
			throw new IllegalArgumentException("HAL profile can't be empty");
		
		if (appId == null || appId.isEmpty())
			throw new IllegalArgumentException("App ID can't be empty");
		
		if (appSecret == null || appSecret.isEmpty())
			throw new IllegalArgumentException("App secret can't be empty");
	}
	
	public static Logger getLogger() {
		return LOGGER;
	}
}
