package com.slimpay;

import org.json.JSONObject;

public class Link {
	protected String rel;
	protected JSONObject attributes;
	
	public Link() {
		rel = null;
		attributes = null;
	}
	
	public Link(String rel) {
		this.rel = rel;
		attributes = null;
	}
	
	public Link(String rel, JSONObject attributes) {
		this.rel = rel;
		this.attributes = attributes;
	}

	public String getRel() {
		return rel;
	}

	public void setRel(String rel) {
		this.rel = rel;
	}

	public JSONObject getAttributes() {
		return attributes;
	}

	public void setAttributes(JSONObject attributes) {
		this.attributes = attributes;
	}

	public String getAttribute(String key) {
		return attributes != null ? attributes.getString(key) : null;
	}

	public void setAttribute(String key, String value) {
		if (attributes == null)
			attributes = new JSONObject();
		
		attributes.put(key, value);
	}

	@Override
	public String toString() {
		return "Link [rel=" + rel + ", attributes=" + attributes.toString(4) + "]";
	}
}
